/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("pdfviewer/pdfjs.min",["kendo.core.min"],function(){var e=window.kendo.jQuery,t=void 0,o,i;return(0,e.extend)(kendo,{pdfviewer:{pdfjs:{lib:window.pdfjsLib,isLoaded:function(){if(!window.pdfjsLib){var e=window.console;if(e&&e.error)e.error("PDF.JS required.");return false}kendo.pdfviewer.pdfjs.lib=window.pdfjsLib;return true}}}}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/processors/pdfjs-processor.min",["../pdfjs.min"],function(){var e={id:"pdfjs-processor",name:"PDFJS-Processor",category:"framework",depends:["core"]},r=window.kendo.jQuery,t=void 0,n=window.kendo,o=n.Class,i=r.extend,s=window.atob,l,a=o.extend({init:function(e,t){var o=this;if(n.pdfviewer.pdfjs.isLoaded())l=n.pdfviewer.pdfjs.lib;o.file=e.file;o.viewer=t},fetchDocument:function(){var i=this,n=r.Deferred(),a=i.viewer.options.messages.errorMessages;if(!i.file)return n.resolve();if(i._isBase64Data()&&s)i.file.data=s(i.file.data);l.getDocument(this.file).promise.then(function(t){var o=[];i.pdf=t;i.pagePromises=[];i._downloadData=r.Deferred();t.getData().then(function(e){var t=new Blob([e],{type:"application/pdf"});i._downloadData.resolve({file:t})});for(var e=1;e<=t.numPages;e++)i.pagePromises.push(t.getPage(e));Promise.all(i.pagePromises).then(function(e){o=e.map(function(e){var t=e.getViewport({scale:4/3});return{width:t.width,height:t.height}});n.resolve({total:t.numPages,pages:o})}).catch(function(e){i.viewer._triggerError({error:e.message,message:a.parseError})})}).catch(function(e){var t=e.name.includes("Missing");var o=t?a.notFound:a.parseError;i.viewer._triggerError({error:e.message,message:o});if(t)i.viewer._renderBlankPage()});return n},fetchPageData:function(e){return this.pagePromises[e-1]},downloadFile:function(o){var i=this;n.ui.progress(i.viewer.pageContainer,true);i._downloadData.done(function(e){n.ui.progress(i.viewer.pageContainer,false);var t=new FileReader;t.readAsDataURL(e.file);t.onload=function(){n.saveAs({dataURI:t.result,fileName:o+".pdf",proxyURL:function(){return t.result}})}})},_updateDocument:function(e){if(this.pdf&&this.pdf.loadingTask)this.pdf.loadingTask.destroy();this.file=e},_isBase64Data:function(){var e=this.file.data,t=/[^A-Z0-9+\/=]/i,o=e&&e.length,i;if(!o||o%4!==0||t.test(e))return false;i=e.indexOf("=");return i===-1||i===o-1||i===o-2&&e[o-1]==="="},renderTextLayer:function(e){l.renderTextLayer(e)}});return i(n.pdfviewer.pdfjs,{processor:a}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/processors/dpl-processor.min",["kendo.core.min"],function(){var e={id:"dpl-processor",name:"DPL-Processor",category:"framework",depends:["core"]},a=window.kendo.jQuery,t=void 0,n=window.kendo,o=a.extend,i,r=n.Class.extend({init:function(e,t){var o=this;o.options=e;o.read=e.read;o.upload=e.upload;o.download=e.download;o.viewer=t},fetchDocument:function(){var t=this,o=a.Deferred(),i=t.viewer.options.messages.errorMessages;if(!t.read)return o.resolve();a.ajax({type:t.read.type,url:t.read.url,dataType:t.read.dataType,success:function(e){if(typeof e!="string")e=n.stringify(e);o.resolve(JSON.parse(e))},error:function(e){t.viewer._triggerError({error:e.responseText,message:i.parseError})}});return o},fetchPageData:function(e){var t=this;var o=a.Deferred();var i=t.viewer.document.pages[e-1];var n={};n[t.read.pageField]=e;if(!i.geometries.length)a.ajax({type:t.read.type,url:t.read.url,data:n,success:function(e){o.resolve(JSON.parse(e))},error:function(e){t.viewer._triggerError({error:e.responseText,message:t.viewer.options.messages.errorMessages.parseError})}});else o.resolve(i);return o},downloadFile:function(e){window.location=this.download.url+"?file="+e},fromJSON:function(e){var t=this.viewer;t._clearPages();t.document=e;t.document.total=t.document.pages.length;t._renderPages();t.resize(true);t.activatePage(1)}});return o(n.pdfviewer,{dpl:{processor:r}}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/pager.min",["kendo.core.min"],function(){var s=window.kendo.jQuery,t=void 0,r=".kendoPDFViewer",i=kendo.ui.Widget,o="change",n="keydown",e=kendo.support.click,p=480,a=kendo.attr,u=s.extend,l=".",d="aria-disabled",c={wrapperClass:"k-pager-wrap k-button-group",iconFirst:"k-i-arrow-end-left",iconLast:"k-i-arrow-end-right",iconPrev:"k-i-arrow-60-left",iconNext:"k-i-arrow-60-right",first:"k-pager-first",last:"k-pager-last",nav:"k-pager-nav",disabled:"k-disabled"},g=i.extend({init:function(e,t){var o=this;i.fn.init.call(o,e,t);o.linkTemplate=kendo.template(o.options.linkTemplate);o.element.addClass(c.wrapperClass);o._renderLinks();o._toggleDisabledClass();o._attachEvents()},options:{linkTemplate:'<a role="button" href="\\#" aria-label="#=text#" title="#=text#" class="k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button k-pager-nav #= wrapClass #" data-page="#=pageIdx#"><span class="k-button-icon k-icon #= iconClass #"></span></a>',previousNext:true,input:true,page:1,total:1,messages:{}},events:[o],_pagerLink:function(e,t,o,i){return this.linkTemplate({iconClass:e,text:t,wrapClass:i||"",pageIdx:o})},_renderLinks:function(){var e=this,t=e.options;if(t.previousNext){e.firstLink=s(e._pagerLink(c.iconFirst,t.messages.first,1,c.first));e.prevLink=s(e._pagerLink(c.iconPrev,t.messages.previous,t.page-1));e.nextLink=s(e._pagerLink(c.iconNext,t.messages.next,t.page+1));e.lastLink=s(e._pagerLink(c.iconLast,t.messages.last,t.total,c.last))}e.element.append(e.firstLink);e.element.append(e.prevLink);if(t.input)e._renderInput();e.element.append(e.nextLink);e.element.append(e.lastLink)},_toggleDisabledClass:function(){var e=this,t=e.options,o=!t.total;if(e.nextLink&&e.prevLink){e.prevLink.toggleClass(c.disabled,o||t.page===1);e.nextLink.toggleClass(c.disabled,o||t.page===t.total);e.lastLink.toggleClass(c.disabled,o||t.page===t.total);e.firstLink.toggleClass(c.disabled,o||t.page===1);e.prevLink.attr(d,o||t.page===1);e.firstLink.attr(d,o||t.page===1);e.nextLink.attr(d,t.page===t.total);e.lastLink.attr(d,t.page===t.total)}if(e.input){e.input.toggleClass(c.disabled,t.total<=1);e.input.attr(d,t.total<=1)}},_attachEvents:function(){var t=this;t.element.on(e+r,l+c.nav,t._click.bind(t));t.element.on(n+r,l+c.nav,function(e){if(e.keyCode===kendo.keys.ENTER){t._click(e);e.preventDefault()}});if(t.input)t.input.on(n+r,t._keydown.bind(t))},_click:function(e){var t=s(e.currentTarget);var o=parseInt(t.attr(a("page")),10);if(e.isDefaultPrevented())return;this._change(o)},_keydown:function(e){var t=e.keyCode,o=kendo.keys,i=s(e.target),n=parseInt(i.val(),10),a=t===o.UP||t===o.DOWN,r=a&&t===o.UP?1:-1;if(a)n+=r;if(t===o.ENTER||a){if(isNaN(n)||n<1||n>this.options.total){n=this.options.page;i.val(n);return}this._change(n);e.preventDefault()}},_change:function(e){var t=this;if(e>=1&&e<=t.options.total){t.options.page=e;if(t.input)t.input.val(e);t.prevLink.attr(a("page"),e-1);t.nextLink.attr(a("page"),e+1);t._toggleDisabledClass()}t.trigger(o,{page:e})},setOptions:function(e){var t=this,o=t.options.total;e=s.extend(t.options,e);i.fn.setOptions.call(t,e);if(e.input)if(o!=e.total){t._renderInput();t.input.on(n+r,t._keydown.bind(t))}else t.input.val(e.total>0?e.page:1);if(e.total>1){t.prevLink.attr(a("page"),e.page-1);t.nextLink.attr(a("page"),e.page+1);t.lastLink.attr(a("page"),e.total)}t._toggleDisabledClass()},_renderInput:function(){var e=this,t,o=e.options,i=e.element.parent().width()<=p,n,a=e.element.find(".k-pager-input");if(e.input)e.input.off(r);t=o.total>0?kendo.format(o.messages.of,o.total):"";if(!i)t+=o.total>1?o.messages.pages:o.messages.page;n='<span class="k-textbox k-input k-input-md k-rounded-md k-input-solid"><input class="k-input-inner" aria-label="'+o.page+t+'"></span>'+t;if(a.length)a.html(n);else e.element.append('<span class="k-pager-input k-label">'+n+"</span>");e.input=e.element.find("input").val(o.total>0?o.page:1)},destroy:function(){this.element.off(r);if(this.input)this.input.off(r);i.fn.destroy.call(this)}});return u(kendo.pdfviewer,{Pager:g}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/toolbar.min",["kendo.toolbar.min","kendo.combobox.min","./pager.min"],function(){var s=window.kendo.jQuery,o=void 0,l=window.kendo,a=s.extend,t="action",i="keydown",u="change",g="command",r=".",e=l.toolbar.Item,h=l.toolbar.TemplateItem,n=l.ui.ToolBar,d={auto:"auto",actual:"actual",fitToWidth:"fitToWidth",fitToPage:"fitToPage"},c={zoomOutIcon:"k-i-zoom-out",zoomInIcon:"k-i-zoom-in"},f=l.template('<select title="#=zoomLevel#" aria-label="#=zoomLevel#">'+"#for(var zoomIndex in zoomLevels){#"+"# var zoomLevel = zoomLevels[zoomIndex]; #"+'<option value="#= zoomLevel.percent || (zoomLevel + "%") #">${zoomLevel.text ? zoomLevel.text : zoomLevel + "%"}</option>'+"#}#"+"</select>"),p={pager:{type:"pager",overflow:"never",command:"PageChangeCommand"},spacer:{type:"spacer"},zoomInOut:{type:"buttonGroup",attributes:{class:"k-zoom-in-out-group"},buttons:[{type:"button",icon:"zoom-out",name:"zoomOut",command:"ZoomCommand",showText:"overflow",options:"zoomOut"},{type:"button",icon:"zoom-in",name:"zoomIn",command:"ZoomCommand",showText:"overflow",options:"zoomIn"}]},zoom:{type:"zoom",command:"ZoomCommand",combobox:{zoomLevels:[50,100,150,200,300,400]},enable:false,overflow:"never"},toggleSelection:{type:"buttonGroup",attributes:{class:"k-toggle-selection-group"},buttons:[{togglable:true,text:"Enable Selection",command:"EnableSelectionCommand",icon:"cursor",showText:"overflow",name:"toggleSelection",group:"toggle-pan"},{togglable:true,text:"Enable Panning",command:"EnablePanCommand",icon:"hand",showText:"overflow",name:"togglePan",group:"toggle-pan",selected:true}]},spacer2:{type:"spacer"},search:{type:"button",text:"Search",command:"OpenSearchCommand",icon:"search",name:"search",showText:"overflow",enable:false},open:{type:"button",text:"Open",showText:"overflow",name:"open",icon:"folder-open",command:"OpenCommand"},download:{type:"button",text:"Download",showText:"overflow",name:"download",icon:"download",command:"DownloadCommand",enable:false},print:{type:"button",text:"Print",showText:"overflow",name:"print",icon:"print",command:"PrintCommand",enable:false}},m=a({},p,{exportAs:{type:"button",text:"Export",showText:"overflow",name:"exportAs",icon:"image-export",command:"ExportCommand"}}),v=e.extend({init:function(e,t){var o=s("<div />");this.options=a(true,e,t.options.pager);this.toolbar=t;this.toolbar.pager=new l.pdfviewer.Pager(o,a({},e,{change:this._change.bind(this)}));this.element=o;this.element.on(i,this._keydown.bind(this));this.attributes();this.addUidAttr();this.addOverflowAttr()},_change:function(e){if(this.options.change&&this.options.change(e.page))return;this.toolbar.action({command:"PageChangeCommand",options:{value:e.page}})},_keydown:function(e){var t=this,o=s(e.target),i=e.keyCode,n=t.element.find(":kendoFocusable"),a=n.index(o),r=l.keys;if(i===r.RIGHT&&n[a+1]){n[a+1].focus();e.preventDefault();e.stopPropagation()}else if(i===r.LEFT&&n[a-1]){n[a-1].focus();e.preventDefault();e.stopPropagation()}}}),w=(l.toolbar.registerComponent("pager",v),e.extend({init:function(e,t){this.options=a(true,e,{messages:t.options.messages.zoom});h.fn.init.call(this,"",e,t);this.toolbar.zoom=this;if(t.options.scale)this._initValue=t.options.scale*100+"%";if(this.options.combobox)this._buildComboBox();this.enable(e.enable)},_buildComboBox:function(){var e=this,t,o=e.options.messages,i=e.options.combobox,n=[{percent:d.auto,text:o.autoWidth},{percent:d.actual,text:o.actualWidth},{percent:d.fitToWidth,text:o.fitToWidth},{percent:d.fitToPage,text:o.fitToPage}];n=n.concat(i.zoomLevels);t=s(f({zoomLevels:n,zoomLevel:o.zoomLevel}));if(!l.support.mobileOS){t=t.kendoComboBox(a({autoWidth:true,clearButton:false,value:e._initValue},i)).getKendoComboBox();e.element.append(t.wrapper);e.combobox=t;e._currentValue=t.value()}else e.element.append(t);t.bind(u,l.throttle(e.change.bind(e),300))},change:function(e){var t=e.sender?e.sender.value():e.target.value,o;if(t.toString().match(/^[0-9]+%?$/))o=parseInt(t.replace("%",""),10)/100;else if(!d[t]){if(this.combobox)this.combobox.value(this._currentValue);e.preventDefault();return}this._currentValue=t;this.toolbar.action({command:"ZoomCommand",options:{scale:o||t}})},enable:function(e){var t=this.element;t.find(".k-button, select").toggleClass("k-disabled",!e);if(this.combobox)this.combobox.enable(e)},destroy:function(){if(this.combobox)this.combobox.destroy()}})),b=(l.toolbar.registerComponent("zoom",w),n.extend({init:function(e,t){var o=this;var i=t.items&&t.items.length?t.items:Object.keys(p);o.options=t;t.items=o._updateItems(i);n.fn.init.call(o,e,t);o.bind({click:o._click,toggle:o._click});t.viewer.bind({update:o._update.bind(o)})},events:[t],_updateItems:function(e){var a=this;var r=this.options.messages;return e.map(function(e){var t=s.isPlainObject(e)&&Object.keys(e).length===1&&e.name;e=t?e.name:e;var o=s.isPlainObject(e)?e:m[e];var i;var n=o.name;if(e.name==="zoomIn"||e.name==="zoomOut")e.text=a.options.messages.zoom[e.name];else if(e==="zoom"||e.name==="zoom"||e.type==="zoom")e.overflow="never";if(o.type==="buttonGroup")o.buttons=a._updateItems(o.buttons);else if(o.type!=="pager")i={name:n,attributes:{"aria-label":r[n],title:r[n],"data-command":o.command},overflow:o.overflow,fillMode:"flat"};else i={overflow:"never"};if(o.text)i.text=r[o.name]||o.text;l.deepExtend(o,i);return o})},_click:function(e){var t=s(e.target).closest(".k-button"),o=t.data(g),i=t.find(r+c.zoomInIcon).length>0,n=t.find(r+c.zoomOutIcon).length>0,a;if(!o)return;a=s.extend({},e.options,{zoomIn:i,zoomOut:n,updateComboBox:i||n});this.action({command:o,options:a})},_update:function(e){var t={page:e.page||1,total:e.total||1},o=this.element.find(":kendoFocusable").not("[tabindex=-1]");if(this.zoom){this.zoom.enable(!e.isBlank);if(e.action==="zoom")this._updateZoomComboBox(e.zoom)}if((e.action==="pagechange"||e.isBlank)&&this.pager)this.pager.setOptions(t);this.enable(this.wrapper.find(".k-toggle-selection-group"),!e.isBlank);this.enable(this.wrapper.find(".k-zoom-in-out-group"),!e.isBlank);this.enable(this.wrapper.find("[data-command='OpenSearchCommand']"),!e.isBlank);this.enable(this.wrapper.find("[data-command='DownloadCommand']"),!e.isBlank);this.enable(this.wrapper.find("[data-command='PrintCommand']"),!e.isBlank);this.element.find(":kendoFocusable").not("[tabindex=-1]").attr("tabindex",-1);o.attr("tabindex",0)},_updateZoomComboBox:function(e){var t=e===d.auto||e===d.actual||e===d.fitToPage||e===d.fitToWidth;if(!t)e=Math.round(e*100)+"%";if(this.zoom&&this.zoom.combobox){this.zoom._currentValue=e;this.zoom.combobox.value(e)}},action:function(e){this.trigger(t,e)},destroy:function(){if(this.pager)this.pager.destroy();if(this.zoom)this.zoom.destroy();n.fn.destroy.call(this)}}));return a(l.pdfviewer,{Toolbar:b,DefaultTools:p}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/page.min",["kendo.drawing.min"],function(){var n=window.kendo.jQuery,t=void 0,o=n.extend,p,l=kendo.drawing,i=l.Group,a=l.Surface,r="render",e=kendo.Class,s=2,d={Path:"path",MultiPath:"multipath",Rect:"rect",Image:"image",Text:"text"},c=e.extend({init:function(e,t){this.viewer=t;this.processor=e.processor;this.options=e;this.pageNumber=e.number;this.element=n("<div class='k-page' />");this.element.attr(kendo.attr("number"),this.pageNumber);this._updatePageSize(e);this.width=e.width;this.height=e.height},resize:function(e){var t=this.element;this._updatePageSize({width:Math.min(t.width()*e,this.width),height:Math.min(t.height()*e,this.height)})},_updatePageSize:function(e){this.element.width(e.width).height(e.height)},destroy:function(){kendo.destroy(this.element)},render:n.noop}),u=c.extend({draw:function(){var e=this,t=e.options.geometries;e.group=new i;e.surface.draw(e.group);e._drawGeometries(t);e.viewer.trigger(r,{page:this});kendo.ui.progress(e.element,false)},load:function(){var t=this;if(t.loaded||!t.processor)return;t.processor.fetchPageData(t.pageNumber).then(function(e){t.options=e;t._initSurface();t.draw()});t.loaded=true},_initSurface:function(){var e={width:this.element.width(),height:this.element.height()};var t=o({width:this.width,height:this.height},this.viewer.options.view);this.surface=new a(this.element,t);this._updatePageSize(e)},_drawGeometries:function(e){var t=this,o;if(!e)return;for(var i=0;i<=e.length;i++){var n=e[i];if(!n)continue;switch(n.type){case d.Path:case d.MultiPath:o=t._drawPath(n);break;case d.Rect:o=t._drawRect(n);break;case d.Image:o=t._drawImage(n);break;case d.Text:o=t._drawText(n);break;default:o=null;break}if(o)t.group.append(o)}},_drawRect:function(e){var t=new kendo.geometry.Rect(e.point,e.size);return new l.Rect(t,{transform:this._getMatrix(e.transform),fill:e.fillOptions,stroke:e.strokeOptions})},_drawImage:function(e){var t=new kendo.geometry.Rect(e.point,e.size);return new l.Image(e.src,t,{transform:this._getMatrix(e.transform)})},_drawText:function(e){var t={transform:this._getMatrix(e.transform),stroke:e.strokeOptions,fill:e.fillOptions,font:e.font};return new kendo.drawing.Text(e.content,e.point,t)},_drawPath:function(e){var t={transform:this._getMatrix(e.transform),stroke:e.strokeOptions,fill:e.fillOptions};var o=new l.MultiPath(t);for(var i=0;i<e.paths.length;i++){var n=e.paths[i];if(!n.segments)return;o.moveTo.apply(o,n.point);for(var a=0;a<n.segments.length;a++){var r=n.segments[a];var s=r.points.length===1?o.lineTo:o.curveTo;s.apply(o,r.points)}if(n.closed)o.close()}return o},_getMatrix:function(e){var t=Object.create(kendo.geometry.Matrix.prototype);kendo.geometry.Matrix.apply(t,e);return t}}),g=c.extend({init:function(e,t){var o=this,i;i=n("<canvas style='width: 100%; height: 100%;' />");o.canvas=i.get(0);c.fn.init.call(o,e,t);o.canvas.width=o.width;o.canvas.height=o.height;o.element.append(i)},load:function(t,e){var o=this,i=n.Deferred();if(o._scale===t&&!e)return;else if(o._scale&&o._scale!==t&&!e){o._scale=t;o.render(t);return i.resolve(o)}if(o.processor)o.processor.fetchPageData(o.pageNumber).then(function(e){o._page=e;o._renderPromise=o.render(t).then(function(){o.viewer.trigger(r,{page:o})});i.resolve(o)});o._scale=t;o.loaded=true;return i},render:function(e){var t=this;var o=window.devicePixelRatio>=s?window.devicePixelRatio:s;var i=this.canvas.getContext("2d"),n=this._page.getViewport({scale:e});this.canvas.width=n.width*o;this.canvas.height=n.height*o;i.scale(o,o);this._scale=e;this._dpr=o;if(this._renderTask){this._renderTask.cancel();this._renderTask=null}this._updatePageSize({width:n.width,height:n.height});this._renderTask=this._page.render({canvasContext:i,viewport:n});this._renderTextLayer(n);return this._renderTask.promise.then(function(){t._renderTask=null}).catch(function(){})},_renderTextLayer:function(o){var i=this;var e=i._page;if(i.textLayer)i.textLayer.remove();i.textLayer=n("<div class='k-text-layer'></div>").get(0);i.element.append(i.textLayer);e.getTextContent({normalizeWhitespace:true}).then(function(e){n(i.textLayer).css({height:o.height,width:o.width}).html("");var t={textContent:e,container:i.textLayer,viewport:o,textDivs:[],enhanceTextSelection:true};i.processor.renderTextLayer(t)})}});return o(kendo.pdfviewer.dpl,{geometryTypes:d,Page:u}),o(kendo.pdfviewer.pdfjs,{Page:g}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/search.min",["kendo.core.min"],function(){var a=window.kendo.jQuery,e=void 0,t=kendo.Class,o=a.extend,i=Array.isArray,n=t.extend({init:function(e){var t=this;t.options=o({},t.options,e);t.processDom()},options:{highlightClass:"k-search-highlight",charClass:"k-text-char"},processDom:function(){var t=this;t.targets=i(t.options.target)?t.options.target:[t.options.target];t.textNodes=[];t.charIndex=0;t.text="";t.targets.forEach(function(e){t.traverseToTextNode(e)});for(var e=0;e<t.textNodes.length;e++)t.processTextNode(t.textNodes[e])},traverseToTextNode:function(e){var t=this;if(e.nodeType===3)t.textNodes.push(e);else for(var o=0;o<e.childNodes.length;o++)t.traverseToTextNode(e.childNodes[o])},processTextNode:function(e){var t=this;var o=e.textContent;var i;t.text=t.text+o;if(o.length>0){i=a(e).wrap("<span>").parent();i.empty();t.splitChars(i.get(0),o);i.children().unwrap()}},splitChars:function(e,t){var o=this;var i="";for(var n=0;n<t.length;n++){i=i+"<span class='"+o.options.charClass+"' "+kendo.attr("char-index")+"="+o.charIndex+">"+t[n]+"</span>";o.charIndex++}e.innerHTML=i},search:function(e,t){var o=this;var i=new RegExp(e,!t?"gi":"g");var n;o.matches=[];o.resetMark();o.resetHighlight();o.resetMatchIndex();if(e==="")return;n=i.exec(o.text);while(n){o.matches.push({startOffset:n.index,endOffset:n.index+n[0].length});n=i.exec(o.text)}o.highlightAll();o.mark()},highlightAll:function(){var n=this;n.matches.forEach(function(e,t){var o=e.startOffset;var i=e.endOffset;n.highlight(o,i,t+1)})},highlight:function(e,t,o){var i=this;for(var n=e;n<t;n++)a(i.targets).find("."+i.options.charClass+"["+kendo.attr("char-index")+"="+n+"]").addClass(i.options.highlightClass).attr(kendo.attr("match-index"),o)},resetHighlight:function(){var e=this;a(e.targets).find("."+e.options.highlightClass).removeClass(e.options.highlightClass)},resetMatchIndex:function(){var e=this;a(e.targets).find("."+e.options.charClass+"["+kendo.attr("match-index")+"]").removeAttr(kendo.attr("match-index"))},mark:function(){var e=this;if(!e.currentIndex&&e.currentIndex!==0)e.currentIndex=0;else if(e.currentIndex>e.matches.length)e.currentIndex=e.matches.length;else e.resetMark();a(e.targets).find("."+e.options.charClass+"["+kendo.attr("match-index")+"="+e.currentIndex+"]").wrapInner("<mark>")},resetMark:function(){var e=this;a(e.targets).find("mark").contents().unwrap()},nextMatch:function(){var e=this;e.currentIndex++;if(e.currentIndex>e.matches.length)e.currentIndex=1;e.mark()},previousMatch:function(){var e=this;e.currentIndex--;if(e.currentIndex<1)e.currentIndex=e.matches.length;e.mark()},getMarkedIndex:function(){return this.matches.length?this.currentIndex:0},getFirstMarked:function(){return a(this.targets).find("mark").eq(0)},destroy:function(){var e=this;e.resetMark();a(e.targets).children("span:not(."+e.options.charClass+")").each(function(e,t){a(t).text(a(t).text())})}});return o(kendo.pdfviewer,{SearchDOM:n}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/dialogs.min",["kendo.dialog.min","kendo.window.min","kendo.binder.min","kendo.numerictextbox.min","kendo.dropdownlist.min"],function(){var n=window.kendo.jQuery,d=void 0,a=window.kendo,r=n.extend,e=a.Class,t={svg:".svg",png:".png"},s=a.keys,o=e.extend({init:function(e){this.options=r(e,{actions:[{text:e.messages.dialogs.okText}]});this._dialog=n("<div />").kendoDialog(this.options).getKendoDialog()},open:function(){this._dialog.center().open()}}),i=e.extend({init:function(e){this.options=r(e,this.options,{fileFormats:[{description:e.messages.dialogs.exportAsDialog.png,extension:t.png},{description:e.messages.dialogs.exportAsDialog.svg,extension:t.svg}],title:e.messages.dialogs.exportAsDialog.title,open:function(){this.center()}});this._initializeDialog();return this},options:{extension:t.png,autoFocus:true,resizable:false,modal:{preventScroll:true},width:"90%",maxWidth:520,template:"<div class='k-edit-label'><label>#: messages.exportAsDialog.labels.fileName #:</label></div>"+"<div class='k-edit-field'>"+"<span class='k-textbox k-input k-input-md k-rounded-md k-input-solid'><input class='k-input-inner' data-bind='value: name' /></span>"+"</div>"+"<div>"+"<div class='k-edit-label'><label>#: messages.exportAsDialog.labels.saveAsType #:</label></div>"+"<div class='k-edit-field'>"+"<select data-role='dropdownlist' class='k-file-format' "+"data-text-field='description' "+"data-value-field='extension' "+"data-bind='value: extension, source: fileFormats'></select>"+"</div>"+"</div>"+"<div class='k-edit-label'><label>#: messages.exportAsDialog.labels.page #:</label></div>"+"<div class='k-edit-field'>"+"<input data-role='numerictextbox' data-format='n0' data-min='1' data-max='#: total #' data-bind='value: page' />"+"</div>"+"<div class='k-action-buttons'>"+"<button class='k-button k-button-md k-rounded-md k-button-solid k-button-solid-primary' data-bind='click: apply'><span class='k-button-text'>#: messages.save #</span></button>"+"<button class='k-button k-button-md k-rounded-md k-button-solid k-button-solid-base' data-bind='click: close'><span class='k-button-text'>#: messages.cancel #</span></button>"+"</div>"},_updateModel:function(e){if(e.pagesCount)this.viewModel.set("pagesCount",e.pagesCount);if(e.page)this.viewModel.set("page",e.page)},_initializeDialog:function(){var e=this;var t=e.options;var o=t.messages.dialogs;var i=n("<div class='k-pdf-viewer-window k-action-window k-popup-edit-form' />").append(a.template(t.template)({total:t.pagesCount,messages:o})).kendoWindow(t).getKendoWindow();e.viewModel=a.observable({title:o.exportAsDialog.title,name:o.exportAsDialog.defaultFileName,extension:t.extension,fileFormats:t.fileFormats,pagesCount:t.pagesCount,page:1,apply:e.apply.bind(this),close:function(){i.close()}});e._dialog=i;a.bind(i.element,e.viewModel);return i},open:function(){this._dialog.center().open()},apply:function(){this._dialog.close();this.options.apply({fileName:this.viewModel.name+this.viewModel.extension,extension:this.viewModel.extension,page:this.viewModel.page})}}),l=e.extend({init:function(e){var t=this;t.options=r({},e,t.options)},options:{resizable:false,template:"<div class='k-search-container'>"+"<button class='k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button k-search-dialog-draghandle'><span class='k-button-icon k-icon k-i-handler-drag'></span></button>"+"<span class='k-textbox k-input k-input-md k-rounded-md k-input-solid'>"+"<input class='k-search-dialog-input k-input-inner' data-bind='value: boundValue, events: { keyup: onKeyup, input: onInput }' aria-label='#: messages.inputLabel #' title='#: messages.inputLabel #' />"+"<span class='k-input-suffix'><button class='k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button k-match-case-button k-match-case-button' data-bind='css: {k-selected: matchCase}, click: matchCaseClick' aria-label='#: messages.matchCase #' title='#: messages.matchCase #'><span class='k-icon k-i-convert-lowercase'></span></button></span>"+"</span>"+"<span class='k-search-matches'><span data-bind='text: matchIndex'></span> #: messages.of # <span data-bind='text: matches'></span></span>"+"<button class='k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button' data-bind='click: prev' aria-label='#: messages.previous #' title='#: messages.previous #'><span class='k-button-icon k-icon k-i-arrow-up'></span></button>"+"<button class='k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button' data-bind='click: next' aria-label='#: messages.next #' title='#: messages.next #'><span class='k-button-icon k-icon k-i-arrow-down'></span></button>"+"<button class='k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button' data-bind='click: close' aria-label='#: messages.close #' title='#: messages.close #'><span class='k-button-icon k-icon k-i-close'></<span></button>"+"</div>"},open:function(){var e=this;if(!e.dialog)e._initializeDialog();e.dialog.open()},_initializeDialog:function(){var e=this;var t=a.template(e.options.template);var o=n("<div class='k-pdf-viewer-search-dialog'></div>").append(t({messages:e.options.messages}));var i={top:e.options.position.top+16,left:e.options.position.left+16};e.dialog=new a.ui.Window(o,r({},e.options,{autoFocus:false,title:false,position:{top:i.top,left:i.left},minHeight:30,draggable:{dragHandle:".k-search-dialog-draghandle"},activate:function(e){e.sender.element.find(".k-search-dialog-input").trigger("focus")}}));e.searchModel=a.observable({boundValue:"",searchText:"",matchCase:false,matchIndex:0,matches:0,matchCaseClick:function(){this.set("matchCase",!this.matchCase)},next:e.options.next,prev:e.options.prev,close:function(){this.set("boundValue","");e.dialog.close()},onKeyup:function(e){var t=e.keyCode;var o=e.shiftKey?this.prev:this.next;if(t===s.ENTER){o();e.preventDefault()}},onInput:function(e){this.set("searchText",e.target.value)}});a.bind(e.dialog.element,e.searchModel)}});return r(a.pdfviewer,{dialogs:{ErrorDialog:o,ExportAsDialog:i,SearchDialog:l}}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("pdfviewer/commands.min",["kendo.upload.min"],function(){var s=window.kendo.jQuery,t=void 0,r=window.kendo,o=s.extend,i=JSON.parse,n=r.ui.progress,p,a="open",d="zoomStart",l="zoomEnd",c=r.Class.extend({init:function(e){this.options=e;this.viewer=e.viewer;this.errorMessages=this.viewer.options.messages.errorMessages}}),e=c.extend({init:function(e){c.fn.init.call(this,e);this.upload=this.viewer.processor.upload},exec:function(){(this.viewer._upload||this._initUpload()).element.click()},_initUpload:function(){var e={select:this._onSelect.bind(this),success:this._onSuccess.bind(this),error:this._onError.bind(this),complete:this._onComplete.bind(this),showFileList:false,multiple:false,validation:{allowedExtensions:[".pdf"]}};if(this.upload)o(e,{async:{saveUrl:this.upload.url,autoUpload:true,saveField:this.upload.saveField}});var t=s('<input name="files" accept=".pdf" type="file" />').kendoUpload(e).getKendoUpload();this.viewer._upload=t;return t},_onComplete:function(){n(this.viewer.pageContainer,false)},_onSuccess:function(e){var t=i(e.response);if(s.isPlainObject(t))this.viewer.processor.fromJSON(t);else this.viewer._triggerError({error:t,message:this.errorMessages.parseError})},_onError:function(e){this.viewer._triggerError({error:e.XMLHttpRequest.responseText,message:this.errorMessages.notSupported})},_onSelect:function(e){var o=this;var t=e.files[0];n(o.viewer.pageContainer,true);if(o.viewer.trigger(a,{file:t})||o.upload)return;else if(t.extension.toLowerCase()!==".pdf"){o.viewer._triggerError({error:t,message:o.errorMessages.notSupported});return}var i=new FileReader;i.onload=function(e){var t=e.target.result;o.viewer.fromFile(t)};i.onerror=function(){o.viewer._triggerError({error:t,message:o.errorMessages.parseError})};i.readAsArrayBuffer(t.rawFile)}}),u=c.extend({exec:function(){var e=this.options.value;this.viewer.activatePage(e)}}),g=c.extend({exec:function(){if(!this.viewer.document){this.viewer._triggerError({message:this.errorMessages.notFound});return}var e=this.viewer.document.info&&this.viewer.document.info.title||this.viewer.options.messages.defaultFileName;this.viewer.processor.downloadFile(e)}}),h=c.extend({init:function(e){e=s.extend(e,this.options);c.fn.init.call(this,e)},exec:function(){var e=this.viewer._saveDialog||this._initDialog();e._updateModel({pagesCount:this.viewer.document&&this.viewer.document.total||1,page:this.viewer.options.page});e.open()},apply:function(e){var t=e.extension;if(t===".png")this.viewer.exportImage(e);else if(t===".svg")this.viewer.exportSVG(e)},_initDialog:function(){this.viewer._saveDialog=new r.pdfviewer.dialogs.ExportAsDialog({apply:this.apply.bind(this),pagesCount:this.viewer.document&&this.viewer.document.total||1,messages:this.viewer.options.messages});return this.viewer._saveDialog}}),f=c.extend({exec:function(){var e=this,t=e.viewer;t._toggleSelection(true)}}),m=c.extend({exec:function(){var e=this,t=e.viewer;t._toggleSelection(false)}}),v=c.extend({init:function(e){var t=this;t.viewer=e.viewer;if(!t.viewer.searchDialog)t.viewer.searchDialog=new r.pdfviewer.dialogs.SearchDialog({position:{top:t.viewer.pageContainer.offset().top,left:t.viewer.pageContainer.offset().left},messages:t.viewer.options.messages.dialogs.search,open:t._open.bind(t),next:t._next.bind(t),prev:t._prev.bind(t),close:t._close.bind(t)});c.fn.init.call(t,e)},exec:function(){var e=this;e.viewer.searchDialog.open()},_open:function(){var e=this;e.changeHandler=e._change.bind(e);e.zoomStartHandler=e._closeDialog.bind(e);e.openFileHandler=e._closeDialog.bind(e);if(!e.viewer._searchDOM){e.viewer._initSearchDOM();e.viewer.searchDialog.searchModel.bind("change",e.changeHandler);e.viewer.bind("zoomStart",e.zoomStartHandler);e.viewer.bind("open",e.openFileHandler)}},_close:function(){var e=this;var t=e.viewer._searchDOM;e.viewer.searchDialog.searchModel.unbind("change",e.changeHandler);e.viewer.unbind("zoomStart",e.zoomStartHandler);e.viewer.unbind("open",e.openFileHandler);t.destroy();delete e.viewer._searchDOM;e._updateSearchModel()},_change:function(e){var t=this;var o=t.viewer._searchDOM;var i=e.field;var n=t.viewer.searchDialog.searchModel;var a=n[i];if(!o)return;switch(i){case"searchText":o.search(a,n.matchCase);t._updateSearchModel();break;case"matchCase":o.search(n.searchText,a);t._updateSearchModel();break;default:break}},_next:function(){var e=this;var t=e.viewer._searchDOM;if(t.matches&&t.matches.length){t.nextMatch();e._updateSearchModel()}},_prev:function(){var e=this;var t=e.viewer._searchDOM;if(t.matches&&t.matches.length){t.previousMatch();e._updateSearchModel()}},_updateSearchModel:function(){var e=this;var t=e.viewer._searchDOM;var o=e.viewer.searchDialog.searchModel;if(t){o.set("matches",t.matches.length);o.set("matchIndex",t.getMarkedIndex());e._scrollToMark()}else{o.set("searchText","");o.set("matches",0);o.set("matchIndex",0);o.set("matchCase",false)}},_scrollToMark:function(){var e=this;var t=e.viewer._searchDOM;var o=t.getFirstMarked();var i=e.viewer._scroller;var n;if(!o.length)return;n=o.offset().top-i.scrollElement.offset().top-100;i.scrollTo(i.scrollLeft,n*-1)},_closeDialog:function(){var e=this;e.viewer.searchDialog.dialog.close()}}),w=c.extend({exec:function(){var o=this,e=o.options,i=o.viewer,n=e.scale,a=0,r=o.viewer._pageNum,s=i.pageContainer[0].clientHeight,l=1,d=[];if(i.processingLib==="dpl")return;n=o._calculateZoom();var t=function(){var e=o.viewer._scroller,t=i._scrollingStarted;if(e&&e.scrollTop>e.scrollHeight())e._resize();if(!t){i.activatePage(r);i._scrollingStarted=false}};if(!n)return;i.zoomScale=n;i._scrollingStarted=false;if(i.pages){i.pages.forEach(function(e){var t;if(i._visiblePages.indexOf(e)!==-1&&e.loaded){d.push(e.render(n));t=e._page.getViewport({scale:n}).height}else{e.resize(n);t=e.element.height()}a+=t;if(a<=s)l++});if(i._visiblePagesCount!=l){i._visiblePagesCount=l;i._loadVisiblePages()}}Promise.all(d).then(function(){t();o._triggerZoomEnd(n)}).catch(function(){t();o._triggerZoomEnd(n)})},_calculateZoom:function(){var e=this.options,t=this.viewer,o=t.options,i=t.pageContainer,n=t._visiblePages&&t._visiblePages[0].canvas,a=t._visiblePages&&t._visiblePages[0]._dpr||2,r=e.scale,s=r,l;t._allowResize=false;t._autoFit=false;if(e.zoomIn)s=r=t.zoomScale+o.zoomRate;else if(e.zoomOut)s=r=t.zoomScale-o.zoomRate;else if(r==="auto"){t._allowResize=true;s=t._autoZoomScale}else if(r==="actual")s=1;else if(r==="fitToWidth"){t._allowResize=true;t._autoFit="fitToWidth";s=i.width()/(n.width/a/t.zoomScale)}else if(r==="fitToPage"){t._allowResize=true;t._autoFit="fitToPage";s=i.height()/(n.height/a/t.zoomScale)}l=r<o.zoomMin||r>o.zoomMax;if(l||t.trigger(d,{scale:r}))return;if(e.updateComboBox&&t.toolbar)t.toolbar._updateZoomComboBox(r);return s},_triggerZoomEnd:function(e){var t=this,o=t.viewer;o.trigger(l,{scale:e})}}),b=c.extend({init:function(e){c.fn.init.call(this,e)},exec:function(){var e=this;if(!e.viewer.document){e.viewer._triggerError({message:this.errorMessages.notFound});return}n(e.viewer.pageContainer,true);e._renderPrintContainer();e._loadAllPages().then(e.processAfterRender.bind(e))},_renderPrintContainer:function(){this.printContainer=s("<div></div>")},_loadAllPages:function(){var e=this;var t=e.viewer.pages;var o=[];var i=[];var n=s.Deferred();e._originalScale=e.viewer.zoom();function a(e){i.push(e._renderPromise)}for(var r=0;r<t.length;r++)o.push(t[r].load(3,true).then(a));Promise.all(o).then(function(){n.resolve(i)});return n},processAfterRender:function(e){var t=this;Promise.all(e).then(function(){t._renderPrintPages();setTimeout(function(){t._printDocument();t.viewer.zoom(t._originalScale);n(t.viewer.pageContainer,false);delete t._originalScale},0)})},_renderPrintPages:function(){var e=this.viewer.pages;for(var t=0;t<e.length;t++)this._renderPrintImage(e[t])},_renderPrintImage:function(e){var t=e.canvas;var o=s("<div></div>");var i="<img src='"+t.toDataURL()+"' width='"+e.width+"px' height='"+e.height+"px' />";o.append(i);this.printContainer.append(o)},_printDocument:function(){var e=this;var t=e.viewer.pages;var o=t[0].width;var i=t[0].height;var n=window.open("","","innerWidth="+o+",innerHeight="+i+"location=no,titlebar=no,toolbar=no");var a=r.support.browser;if(!n){e.viewer._triggerError({message:e.errorMessages.popupBlocked});return}n.document.write(e.printContainer.html());n.document.close();n.focus();n.print();if(!a.chrome||a.chromiumEdge)n.close();else s(n.document).find("body").on("mousemove",function(){n.close()})}});return o(r.pdfviewer,{OpenCommand:e,PageChangeCommand:u,DownloadCommand:g,EnableSelectionCommand:f,EnablePanCommand:m,ExportCommand:h,PrintCommand:b,OpenSearchCommand:v,ZoomCommand:w}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("kendo.pdfviewer.min",["kendo.mobile.scroller.min","./pdfviewer/processors/pdfjs-processor.min","./pdfviewer/processors/dpl-processor.min","./pdfviewer/toolbar.min","./pdfviewer/page.min","./pdfviewer/search.min","./pdfviewer/dialogs.min","./pdfviewer/commands.min"],function(){var t={id:"pdfviewer",name:"PDFViewer",category:"web",description:"PDFViewer to display pdfs in the browser",depends:["core","window","dialog","toolbar","mobile.scroller","upload","combobox","drawing","binder","dropdownlist","numerictextbox"]},n=window.kendo.jQuery,a=void 0,e=".kendoPDFViewer",r=window.kendo,p=r.ui,s=n.extend,u=r.drawing,l=n.extend({PLUS:187,MINUS:189,ZERO:48,NUMPAD_ZERO:96},r.keys),g,i=p.Widget,d=r.ui.progress,h="scroll",f,m,v="error",b="focus"+e,k="keydown"+e,x="DOMMouseScroll"+e+" mousewheel"+e,w="update",c=1.25,_="pagechange",C,P,y="ZoomCommand",z="#ffffff",D="tabindex",T={pdfjs:"pdfjs",dpl:"dpl"},o={viewer:"k-pdf-viewer k-widget",scroller:"k-canvas k-list-scroller",enableTextSelection:"k-enable-text-select",enablePanning:"k-enable-panning",highlightClass:"k-search-highlight",charClass:"k-text-char"},S=i.extend({init:function(e,t){var o=this;i.fn.init.call(o,e,r.deepExtend({},this.options,t));o._wrapper();if(o.options.toolbar)o._renderToolbar();o._initProcessor(t||{});o._renderPageContainer();o._loadDocument();o._tabindex();r.notify(o,r.ui)},events:["render","open",v,"zoomStart","zoomEnd"],options:{name:"PDFViewer",view:{type:"canvas"},pdfjsProcessing:{file:null},dplProcessing:{read:{url:null,type:"GET",dataType:"json",pageField:"pageNumber"},upload:{url:null,saveField:"file"},download:{url:null},loadOnDemand:false},toolbar:{items:[]},width:1e3,height:1200,page:1,defaultPageSize:{width:794,height:1123},scale:null,zoomMin:.5,zoomMax:4,zoomRate:.25,messages:{defaultFileName:"Document",toolbar:{zoom:{zoomLevel:"zoom level",zoomOut:"Zoom Out",zoomIn:"Zoom In",actualWidth:"Actual Width",autoWidth:"Automatic Width",fitToWidth:"Fit to Width",fitToPage:"Fit to Page"},open:"Open",exportAs:"Export",download:"Download",pager:{first:"Go to the first page",previous:"Go to the previous page",next:"Go to the next page",last:"Go to the last page",of:" of {0} ",page:"page",pages:"pages"},print:"Print",toggleSelection:"Enable Selection",togglePan:"Enable Panning",search:"Search"},errorMessages:{notSupported:"Only pdf files allowed.",parseError:"PDF file fails to process.",notFound:"File is not found.",popupBlocked:"Popup is blocked."},dialogs:{exportAsDialog:{title:"Export...",defaultFileName:"Document",pdf:"Portable Document Format (.pdf)",png:"Portable Network Graphics (.png)",svg:"Scalable Vector Graphics (.svg)",labels:{fileName:"File name",saveAsType:"Save as",page:"Page"}},okText:"OK",save:"Save",cancel:"Cancel",search:{inputLabel:"Search Text",matchCase:"Match Case",next:"Next Match",previous:"Previous Match",close:"Close",of:"of"}}}},_wrapper:function(){var e=this,t=e.options;e.wrapper=e.element;e.wrapper.width(t.width).height(t.height).addClass(o.viewer).on(b,e._focus.bind(e)).on(k,e._keydown.bind(e));e._allowResize=e.options.scale===null;e._autoZoomScale=c;e.zoomScale=e.options.scale||e._autoZoomScale;e._resizeHandler=r.onResize(function(){e.resize()});e._pageNum=e.options.page},_focus:function(e){if(this.toolbar)this.toolbar.wrapper.trigger("focus");else this.pageContainer.trigger("focus");e.preventDefault()},_keydown:function(e){var t=[l.PLUS,l.NUMPAD_PLUS],o=[l.MINUS,l.NUMPAD_MINUS],i=[l.ZERO,l.NUMPAD_ZERO],n=false,a={command:y,options:{updateComboBox:true}};if(!e.ctrlKey||this._blankPage||this.processingLib===T.dpl)return;if(t.includes(e.keyCode)){a.options.zoomIn=true;n=true}else if(o.includes(e.keyCode)){a.options.zoomOut=true;n=true}else if(i.includes(e.keyCode)){a.options.scale=c;n=true}if(n){this.execute(a);e.preventDefault()}},_initProcessor:function(e){var t=this,o;o=e.dplProcessing?t.options.dplProcessing:t.options.pdfjsProcessing;t.processingLib=e.dplProcessing?T.dpl:T.pdfjs;t.processor=new r.pdfviewer[t.processingLib].processor(o,t);g=r.pdfviewer[t.processingLib].Page},_renderToolbar:function(){var e=this,t=e.options;var o={pager:{messages:t.messages.toolbar.pager},scale:t.scale,resizable:true,items:t.toolbar.items,width:t.width,action:e.execute.bind(e),messages:t.messages.toolbar,viewer:this};var i=n("<div />");i.appendTo(e.element);e.toolbar=new r.pdfviewer.Toolbar(i,o)},_initErrorDialog:function(e){var t=this;if(!t._errorDialog){e=s(e,{messages:t.options.messages});var o=new r.pdfviewer.dialogs.ErrorDialog(e);t._errorDialog=o._dialog}return t._errorDialog},_renderPageContainer:function(){var e=this;if(!e.pageContainer){e.pageContainer=n("<div />");e.pageContainer.addClass(o.scroller);e.pageContainer.attr(D,0);e.wrapper.append(e.pageContainer)}},_triggerError:function(e){var t=this._initErrorDialog();s(e,{dialog:t});if(this.pageContainer)d(this.pageContainer,false);if(this.trigger(v,e))return;t.open().content(e.message)},_renderPages:function(){var e=this,t=e.document,o;e.pages=[];if(!t||!t.total){e._renderBlankPage();return}o=t.pages;for(var i=1;i<=t.total;i++){var n,a={processor:e.processor,number:i};if(o&&o.length)a=s(a,o[i-1]);n=new g(a,e);e.pages.push(n);e.pageContainer.append(n.element)}e._attachContainerEvents();e._getVisiblePagesCount()},_renderBlankPage:function(){this._blankPage=new g(this.options.defaultPageSize,this);this.pageContainer.append(this._blankPage.element);this.trigger(w,{isBlank:true})},_resize:function(){var e=this,t,o;if(!e._allowResize)return;if(!e.pages||!e.pages.length){if(e._blankPage){o=t/e._blankPage.element.width();e._blankPage.resize(o)}return}if(e.toolbar)e.toolbar.resize(true);if(e._resizeHandler)clearTimeout(e._resizeHandler);e._resizeHandler=setTimeout(e._resizePages.bind(e),100)},_resizePages:function(){var e=this,o=e.pageContainer[0].clientWidth,i=0;e.pages.forEach(function(e){var t=o/e.element.width();if(t>i)i=t});if(e._autoFit){e.zoom(e._autoFit,true);return}i=Math.min(Math.max(i,e.options.zoomMin),c);if(i!=e.zoomScale){e.zoom(i,true);e.zoomScale=i;e._allowResize=true}},_attachContainerEvents:function(){var t=this;t._wheel=r.throttle(t._wheel.bind(t),300);if(t.processingLib!==T.dpl)t.pageContainer.on(x,function(e){if(!e.ctrlKey)return;if(document.activeElement!==t.pageContainer[0])t.pageContainer.trigger("focus");t._wheel(e);e.preventDefault()});t._scroller=new r.mobile.ui.Scroller(t.pageContainer,{zoom:false,elastic:true});t._scroller.scrollElement.addClass(o.enablePanning);t._scroller.bind(h,t._scroll.bind(this))},_scroll:function(c){var e=this,p=e.pageContainer[0].scrollHeight,u=e.pageContainer.height(),t=c.scrollTop,g=e.pageContainer.offset().top,o=e.pages.length,i=e._pageNum,n=i-1,a=i,h,r,s,f,l,m,v,d=t-e._prevScrollTop>0?1:-1;if(e._preventScroll||!o){e._preventScroll=false;return}e._scrollingStarted=true;r=e.pages[n];s=r.element.offset().top-g;f=r.element.height();if(d==-1&&e.pages[n+d]){l=e.pages[n-e._visiblePagesCount]||e.pages[n+d];m=l.element.offset().top-g;v=l.element.height()}if(Math.abs(t-(e._prevScrollTop||0))>u*e.zoomScale)a=Math.floor(t*(1/(p/o)))+1;else if(s<0&&Math.abs(s)>=f/2&&d===1)a++;else if(l&&Math.abs(m)<=v/2)a--;if(i!==a&&a>=1&&a<=o){h=e.pages[a-1].element;if(h.offset().top>u)return;e._pageNum=a;e._loadVisiblePages();e.trigger(w,{action:_,page:a,total:o})}e._prevScrollTop=t},_wheel:function(e){var t=e.originalEvent,o=t.wheelDelta?-t.wheelDelta:t.detail,i=o<0;this.execute({command:y,options:{zoomIn:i,zoomOut:!i,updateComboBox:true}});e.preventDefault()},zoom:function(e,t){var o=this;if(!e)return o.zoomScale;return o.execute({command:y,options:{scale:e,updateComboBox:!t}})},execute:function(e){var t=s({viewer:this},e.options);var o=new r.pdfviewer[e.command](t);return o.exec()},_loadDocument:function(){var t=this;var o=t.options.page;d(t.pageContainer,true);t.processor.fetchDocument().done(function(e){t._clearPages();t.document=e;t._renderPages();t.resize(true);if(e){o=o>=1&&o<=e.total?o:1;t.activatePage(o)}d(t.pageContainer,false)})},loadPage:function(e){var t=this.pages&&this.pages[e-1];if(t)return t.load(this.zoomScale)},activatePage:function(e){var t=this.pages&&this.pages[e-1],o=this._scroller,i,n,a,r;if(!t)return;i=o.scrollTop;n=o.element.offset().top;a=t.element.offset().top;r=!this._autoFit?parseInt(t.element.css("marginTop"),10):0;this._pageNum=e;this._loadVisiblePages();this._preventScroll=true;this._scroller.scrollTo(0,-i-a+n+r);this.trigger(w,{action:_,page:e,total:this.pages.length})},_getVisiblePagesCount:function(){var e=this,t=0,o=0,i=e.pageContainer[0].clientHeight,n=0;while(t<=i&&n<e.pages.length){t+=e.pages[n].element.height();o++;n++}e._visiblePagesCount=o},_loadVisiblePages:function(){var e=this.pages&&this.pages.length,t=Math.max(this._pageNum-this._visiblePagesCount,1),o=Math.min(this._pageNum+this._visiblePagesCount,e);this._visiblePages=this.pages.slice(t-1,o);for(var i=t;i<=o;i++)this.loadPage(i)},_loadAllPages:function(){var e=this.pages&&this.pages.length;var t=[];for(var o=0;o<=e;o++)t.push(this.loadPage(o));return t},fromFile:function(e){this.zoomScale=this.options.scale||c;this.zoom(this.zoomScale,true);this.trigger(w,{action:"zoom",zoom:this.options.scale||"auto"});this.processor._updateDocument(e);this._loadDocument()},exportImage:function(t){var o=this;var e=t.page;var i=o.pages[e-1]||o._blankPage;var n=new u.Group;i.load();var a=r.drawing.Path.fromRect(new r.geometry.Rect([0,0],[i.width,i.height]),{fill:{color:z},stroke:null});d(o.pageContainer,true);n.append(a,i.group);u.exportImage(n).done(function(e){d(o.pageContainer,false);r.saveAs({dataURI:e,fileName:t.fileName,proxyURL:t.proxyURL||"",forceProxy:t.forceProxy,proxyTarget:t.proxyTarget})})},exportSVG:function(t){var o=this;var e=t.page;var i=o.pages[e-1]||o._blankPage;d(o.pageContainer,true);i.load();u.exportSVG(i.group).done(function(e){d(o.pageContainer,false);r.saveAs({dataURI:e,fileName:t.fileName,proxyURL:t.proxyURL||"",forceProxy:t.forceProxy,proxyTarget:t.proxyTarget})})},setOptions:function(e){var t=this;if(e.pdfjsProcessing||e.dplProcessing)t._initProcessor(e||{});e=n.extend(t.options,e);i.fn.setOptions.call(t,e);if(e.page){t._pageNum=e.page;t.activatePage(e.page)}if(e.width)t.element.width(e.width);if(e.height)t.element.height(e.height)},destroy:function(){if(this._resizeHandler)r.unbindResize(this._resizeHandler);if(this._errorDialog)this._errorDialog.destroy();if(this._saveDialog)this._saveDialog.destroy();if(this._upload)this._upload.destroy();if(this.toolbar){this.toolbar.unbind();this.toolbar.destroy();this.toolbar=null}if(this.pages&&this.pages.length){this.pages.forEach(function(e){e.destroy()});this.pages=[]}if(this._scroller){this._scroller.unbind();this._scroller.destroy()}this.pageContainer.off(e);i.fn.destroy.call(this)},_clearPages:function(){this.pages=[];this.document=null;this._pageNum=1;this.pageContainer.off(e);this.pageContainer.empty();if(this._scroller){this._scroller.reset();this._scroller.unbind();this._scroller.destroy()}},_toggleSelection:function(e){var t=this;if(e===a)e=true;t._scroller.userEvents._shouldNotMove=e;t._scroller.scrollElement.toggleClass(o.enableTextSelection,e);t._scroller.scrollElement.toggleClass(o.enablePanning,!e)},_initSearchDOM:function(){var t=this;var e=new Promise(function(e){Promise.all(t._loadAllPages()).then(function(){t._searchDOM=new r.pdfviewer.SearchDOM({target:t._getTextLayers(),highlightClass:o.highlightClass,charClass:o.charClass});e()})});return e},_getTextLayers:function(){return this.pages.map(function(e){return e.textLayer})}});return p.plugin(S),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()});
//# sourceMappingURL=kendo.pdfviewer.min.js.map
