/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.dataviz.barcode.min",["kendo.dataviz.core.min","kendo.drawing.min"],function(){var s={id:"dataviz.barcode",name:"Barcode",category:"dataviz",description:"Barcode widget",depends:["dataviz.core"]},n=window.kendo.jQuery,h=void 0,e=window.kendo,u=e.ui.Widget,d=n.extend,l=e.deepExtend,o=n.inArray,p=n.isPlainObject,v=e.drawing,c=e.geometry,g,w=e.drawing.util.defined,f=e.dataviz,b=f.Box2D,m=f.TextBox,S=300,C=100,B=10,x=/^\d+$/,k=/^[a-z0-9]+$/i,A="Character '{0}' is not valid for symbology {1}";function y(t,e,a){return t.substring(e,e+a)}var a=e.Class.extend({init:function(t){this.setOptions(t)},setOptions:function(t){var e=this;e.options=d({},e.options,t);e.quietZoneLength=e.options.addQuietZone?2*e.options.quietZoneLength:0},encode:function(t,e,a){var n=this;if(w(t))t+="";n.initValue(t,e,a);if(n.options.addQuietZone)n.addQuietZone();n.addData();if(n.options.addQuietZone)n.addQuietZone();return{baseUnit:n.baseUnit,pattern:n.pattern}},options:{quietZoneLength:B,addQuietZone:true,addCheckSum:true},initValue:function(){},addQuietZone:function(){this.pattern.push(this.options.quietZoneLength||B)},addData:function(){},invalidCharacterError:function(t){throw new Error(e.format(A,t,this.name))}}),i={},M=a.extend({minBaseUnitLength:.7,addData:function(){var t=this,e=t.value;t.addStart();for(var a=0;a<e.length;a++)t.addCharacter(e.charAt(a));if(t.options.addCheckSum)t.pushCheckSum();t.addStop();t.prepareValues()},addCharacter:function(t){var e=this,a=e.characterMap[t];if(!a)e.invalidCharacterError(t);e.addBase(a)},addBase:function(){}}),T={addCharacter:function(t){var e=this;if(e.characterMap[t])e.addBase(e.characterMap[t]);else if(t.charCodeAt(0)>127)e.invalidCharacterError(t);else e.addExtended(t.charCodeAt(0))},addExtended:function(t){var e=this,a;for(var n=0;n<e.extendedMappings.length;n++)if(a=e.extendedMappings[n].call(e,t)){for(var i=0;i<a.length;i++)e.addBase(a[i]);e.dataLength+=a.length-1;return}},extendedMappings:[function(t){if(97<=t&&t<=122){var e=this;return[e.characterMap[e.shiftCharacters[0]],e.characterMap[String.fromCharCode(t-32)]]}},function(t){if(33<=t&&t<=58){var e=this;return[e.characterMap[e.shiftCharacters[1]],e.characterMap[String.fromCharCode(t+32)]]}},function(t){if(1<=t&&t<=26){var e=this;return[e.characterMap[e.shiftCharacters[2]],e.characterMap[String.fromCharCode(t+64)]]}},function(t){var e=this,a,n;if(!e.specialAsciiCodes[t]){n=Math.floor(t/32)*6+(t-27)%32+64;a=[e.characterMap[e.shiftCharacters[3]],e.characterMap[String.fromCharCode(n)]]}else{a=[];for(var i=0;i<e.specialAsciiCodes[t].length;i++){a.push(e.characterMap[e.shiftCharacters[3]]);a.push(e.characterMap[e.specialAsciiCodes[t][i]])}}return a}],specialAsciiCodes:{0:["U"],64:["V"],96:["W"],127:["T","X","Y","Z"]},shiftValuesAsciiCodes:{39:36,40:47,41:43,42:37},characterMap:{"+":false,"/":false,$:false,"%":false},shiftCharacters:["SHIFT0","SHIFT1","SHIFT2","SHIFT3"]},W=(i.code39=M.extend({name:"Code 39",checkSumMod:43,minRatio:2.5,maxRatio:3,gapWidth:1,splitCharacter:"|",initValue:function(t,e,a){var n=this;n.width=e;n.height=a;n.value=t;n.dataLength=t.length;n.pattern=[];n.patternString=""},prepareValues:function(){var t=this,e,a=t.minBaseUnitLength,n=t.maxRatio,i=t.minRatio,r=Math.max(.15*t.width,24);if(t.height<r)throw new Error("Insufficient Height. The minimum height for value: "+t.value+" is: "+r);while((e=t.getBaseUnit(n))<a&&n>i)n=parseFloat((n-.1).toFixed(1));if(e<a){var s=Math.ceil(t.getBaseWidth(i)*a);throw new Error("Insufficient width. The minimum width for value: "+t.value+" is: "+s)}t.ratio=n;t.baseUnit=e;t.patternString=t.patternString.substring(0,t.patternString.length-1);t.pattern=t.pattern.concat(t.patternString.replace(/ratio/g,n).split(t.splitCharacter))},getBaseUnit:function(t){return this.width/this.getBaseWidth(t)},getBaseWidth:function(t){var e=this,a=3*(t+2);return e.quietZoneLength+a*(e.dataLength+2)+e.gapWidth*(e.dataLength+1)},addStart:function(){var t=this;t.addPattern(t.characterMap.START.pattern);t.addCharacterGap()},addBase:function(t){this.addPattern(t.pattern);this.addCharacterGap()},addStop:function(){this.addPattern(this.characterMap.START.pattern)},addPattern:function(t){for(var e=0;e<t.length;e++)this.patternString+=this.patternMappings[t.charAt(e)]},addCharacterGap:function(){var t=this;t.patternString+=t.gapWidth+t.splitCharacter},patternMappings:{b:"1|",w:"1|",B:"ratio|",W:"ratio|"},characterMap:{0:{pattern:"bwbWBwBwb",value:0},1:{pattern:"BwbWbwbwB",value:1},2:{pattern:"bwBWbwbwB",value:2},3:{pattern:"BwBWbwbwb",value:3},4:{pattern:"bwbWBwbwB",value:4},5:{pattern:"BwbWBwbwb",value:5},6:{pattern:"bwBWBwbwb",value:6},7:{pattern:"bwbWbwBwB",value:7},8:{pattern:"BwbWbwBwb",value:8},9:{pattern:"bwBWbwBwb",value:9},A:{pattern:"BwbwbWbwB",value:10},B:{pattern:"bwBwbWbwB",value:11},C:{pattern:"BwBwbWbwb",value:12},D:{pattern:"bwbwBWbwB",value:13},E:{pattern:"BwbwBWbwb",value:14},F:{pattern:"bwBwBWbwb",value:15},G:{pattern:"bwbwbWBwB",value:16},H:{pattern:"BwbwbWBwb",value:17},I:{pattern:"bwBwbWBwb",value:18},J:{pattern:"bwbwBWBwb",value:19},K:{pattern:"BwbwbwbWB",value:20},L:{pattern:"bwBwbwbWB",value:21},M:{pattern:"BwBwbwbWb",value:22},N:{pattern:"bwbwBwbWB",value:23},O:{pattern:"BwbwBwbWb",value:24},P:{pattern:"bwBwBwbWb",value:25},Q:{pattern:"bwbwbwBWB",value:26},R:{pattern:"BwbwbwBWb",value:27},S:{pattern:"bwBwbwBWb",value:28},T:{pattern:"bwbwBwBWb",value:29},U:{pattern:"BWbwbwbwB",value:30},V:{pattern:"bWBwbwbwB",value:31},W:{pattern:"BWBwbwbwb",value:32},X:{pattern:"bWbwBwbwB",value:33},Y:{pattern:"BWbwBwbwb",value:34},Z:{pattern:"bWBwBwbwb",value:35},"-":{pattern:"bWbwbwBwB",value:36},".":{pattern:"BWbwbwBwb",value:37}," ":{pattern:"bWBwbwBwb",value:38},$:{pattern:"bWbWbWbwb",value:39},"/":{pattern:"bWbWbwbWb",value:40},"+":{pattern:"bWbwbWbWb",value:41},"%":{pattern:"bwbWbWbWb",value:42},START:{pattern:"bWbwBwBwb"}},options:{addCheckSum:false}}),i.code39extended=i.code39.extend(l({},T,{name:"Code 39 extended",characterMap:{SHIFT0:{pattern:"bWbwbWbWb",value:41},SHIFT1:{pattern:"bWbWbwbWb",value:40},SHIFT2:{pattern:"bWbWbWbwb",value:39},SHIFT3:{pattern:"bwbWbWbWb",value:42}}})),i.code93=M.extend({name:"Code 93",cCheckSumTotal:20,kCheckSumTotal:15,checkSumMod:47,initValue:function(t,e,a){var n=this;n.value=t;n.width=e;n.height=a;n.pattern=[];n.values=[];n.dataLength=t.length},prepareValues:function(){var t=this,e=Math.max(.15*t.width,24);if(t.height<e)throw new Error("Insufficient Height");t.setBaseUnit();if(t.baseUnit<t.minBaseUnitLength)throw new Error("Insufficient Width")},setBaseUnit:function(){var t=this,e=2;t.baseUnit=t.width/(9*(t.dataLength+2+e)+t.quietZoneLength+1)},addStart:function(){var t=this.characterMap.START.pattern;this.addPattern(t)},addStop:function(){var t=this;t.addStart();t.pattern.push(t.characterMap.TERMINATION_BAR)},addBase:function(t){this.addPattern(t.pattern);this.values.push(t.value)},pushCheckSum:function(){var t=this,e=t._getCheckValues(),a;t.checksum=e.join("");for(var n=0;n<e.length;n++){a=t.characterMap[t._findCharacterByValue(e[n])];t.addPattern(a.pattern)}},_getCheckValues:function(){var t=this,e=t.values,a=e.length,n=0,i,r,s;for(s=a-1;s>=0;s--)n+=t.weightedValue(e[s],a-s,t.cCheckSumTotal);i=n%t.checkSumMod;n=t.weightedValue(i,1,t.kCheckSumTotal);for(s=a-1;s>=0;s--)n+=t.weightedValue(e[s],a-s+1,t.kCheckSumTotal);r=n%t.checkSumMod;return[i,r]},_findCharacterByValue:function(t){for(var e in this.characterMap)if(this.characterMap[e].value===t)return e},weightedValue:function(t,e,a){return(e%a||a)*t},addPattern:function(t){var e;for(var a=0;a<t.length;a++){e=parseInt(t.charAt(a),10);this.pattern.push(e)}},characterMap:{0:{pattern:"131112",value:0},1:{pattern:"111213",value:1},2:{pattern:"111312",value:2},3:{pattern:"111411",value:3},4:{pattern:"121113",value:4},5:{pattern:"121212",value:5},6:{pattern:"121311",value:6},7:{pattern:"111114",value:7},8:{pattern:"131211",value:8},9:{pattern:"141111",value:9},A:{pattern:"211113",value:10},B:{pattern:"211212",value:11},C:{pattern:"211311",value:12},D:{pattern:"221112",value:13},E:{pattern:"221211",value:14},F:{pattern:"231111",value:15},G:{pattern:"112113",value:16},H:{pattern:"112212",value:17},I:{pattern:"112311",value:18},J:{pattern:"122112",value:19},K:{pattern:"132111",value:20},L:{pattern:"111123",value:21},M:{pattern:"111222",value:22},N:{pattern:"111321",value:23},O:{pattern:"121122",value:24},P:{pattern:"131121",value:25},Q:{pattern:"212112",value:26},R:{pattern:"212211",value:27},S:{pattern:"211122",value:28},T:{pattern:"211221",value:29},U:{pattern:"221121",value:30},V:{pattern:"222111",value:31},W:{pattern:"112122",value:32},X:{pattern:"112221",value:33},Y:{pattern:"122121",value:34},Z:{pattern:"123111",value:35},"-":{pattern:"121131",value:36},".":{pattern:"311112",value:37}," ":{pattern:"311211",value:38},$:{pattern:"321111",value:39},"/":{pattern:"112131",value:40},"+":{pattern:"113121",value:41},"%":{pattern:"211131",value:42},SHIFT0:{pattern:"122211",value:46},SHIFT1:{pattern:"311121",value:45},SHIFT2:{pattern:"121221",value:43},SHIFT3:{pattern:"312111",value:44},START:{pattern:"111141"},TERMINATION_BAR:"1"}}),i.code93extended=i.code93.extend(l({},T,{name:"Code 93 extended",pushCheckSum:function(){var t=this,e=t._getCheckValues(),a;t.checksum=e.join("");for(var n=0;n<e.length;n++){a=e[n];if(t.shiftValuesAsciiCodes[a])t.addExtended(t.shiftValuesAsciiCodes[a]);else t.addPattern(t.characterMap[t._findCharacterByValue(a)].pattern)}}})),e.Class.extend({init:function(t){this.encoding=t},addStart:function(){},is:function(){},move:function(){},pushState:function(){}})),P=W.extend({FNC4:"FNC4",init:function(t,e){var a=this;a.encoding=t;a.states=e;a._initMoves(e)},addStart:function(){this.encoding.addPattern(this.START)},is:function(t,e){var a=t.charCodeAt(e);return this.isCode(a)},move:function(t){var e=this,a=0;while(!e._moves[a].call(e,t)&&a<e._moves.length)a++},pushState:function(t){var e=this,a=e.states,n=t.value,i=n.length,r;if(o("C",a)>=0){var s=n.substr(t.index).match(/\d{4,}/g);if(s)i=n.indexOf(s[0],t.index)}while((r=t.value.charCodeAt(t.index))>=0&&e.isCode(r)&&t.index<i){e.encoding.addPattern(e.getValue(r));t.index++}},_initMoves:function(t){var e=this;e._moves=[];if(o(e.FNC4,t)>=0)e._moves.push(e._moveFNC);if(o(e.shiftKey,t)>=0)e._moves.push(e._shiftState);e._moves.push(e._moveState)},_moveFNC:function(t){if(t.fnc){t.fnc=false;return t.previousState==this.key}},_shiftState:function(t){var e=this;if(t.previousState==e.shiftKey&&(t.index+1>=t.value.length||e.encoding[e.shiftKey].is(t.value,t.index+1))){e.encoding.addPattern(e.SHIFT);t.shifted=true;return true}},_moveState:function(){this.encoding.addPattern(this.MOVE);return true},SHIFT:98}),r={},t=(r.A=P.extend({key:"A",shiftKey:"B",isCode:function(t){return t>=0&&t<96},getValue:function(t){if(t<32)return t+64;return t-32},MOVE:101,START:103}),r.B=P.extend({key:"B",shiftKey:"A",isCode:function(t){return t>=32&&t<128},getValue:function(t){return t-32},MOVE:100,START:104}),r.C=W.extend({key:"C",addStart:function(){this.encoding.addPattern(this.START)},is:function(t,e){var a=y(t,e,4);return(e+4<=t.length||t.length==2)&&x.test(a)},move:function(){this.encoding.addPattern(this.MOVE)},pushState:function(t){var e;while((e=y(t.value,t.index,2))&&x.test(e)&&e.length==2){this.encoding.addPattern(parseInt(e,10));t.index+=2}},getValue:function(t){return t},MOVE:99,START:105}),r.FNC4=W.extend({key:"FNC4",dependentStates:["A","B"],init:function(t,e){this.encoding=t;this._initSubStates(e)},addStart:function(t){var e=t.value.charCodeAt(0)-128,a=this._getSubState(e);this.encoding[a].addStart()},is:function(t,e){var a=t.charCodeAt(e);return this.isCode(a)},isCode:function(t){return t>=128&&t<256},pushState:function(t){var e=this,a=e._initSubState(t),n=e.encoding,i=a.value.length;t.index+=i;if(i<3){var r;for(;a.index<i;a.index++){r=a.value.charCodeAt(a.index);a.state=e._getSubState(r);if(a.previousState!=a.state){a.previousState=a.state;n[a.state].move(a)}n.addPattern(n[a.state].MOVE);n.addPattern(n[a.state].getValue(r))}}else{if(a.state!=a.previousState)n[a.state].move(a);e._pushStart(a);n.pushData(a,e.subStates);if(t.index<t.value.length)e._pushStart(a)}t.fnc=true;t.state=a.state},_pushStart:function(t){var e=this;e.encoding.addPattern(e.encoding[t.state].MOVE);e.encoding.addPattern(e.encoding[t.state].MOVE)},_initSubState:function(t){var e=this,a={value:e._getAll(t.value,t.index),index:0};a.state=e._getSubState(a.value.charCodeAt(0));a.previousState=t.previousState==e.key?a.state:t.previousState;return a},_initSubStates:function(t){var e=this;e.subStates=[];for(var a=0;a<t.length;a++)if(o(t[a],e.dependentStates)>=0)e.subStates.push(t[a])},_getSubState:function(t){var e=this;for(var a=0;a<e.subStates.length;a++)if(e.encoding[e.subStates[a]].isCode(t))return e.subStates[a]},_getAll:function(t,e){var a,n="";while((a=t.charCodeAt(e++))&&this.isCode(a))n+=String.fromCharCode(a-128);return n}}),r.FNC1=W.extend({key:"FNC1",startState:"C",dependentStates:["C","B"],startAI:"(",endAI:")",init:function(t,e){this.encoding=t;this.states=e},addStart:function(){this.encoding[this.startState].addStart()},is:function(){return o(this.key,this.states)>=0},pushState:function(t){var e=this,a=e.encoding,n=t.value.replace(/\s/g,""),i=new RegExp("["+e.startAI+e.endAI+"]","g"),r=t.index,s={state:e.startState},o,h,u;a.addPattern(e.START);while(true){s.index=0;u=n.charAt(r)===e.startAI?2:0;o=u>0?e.getBySeparator(n,r):e.getByLength(n,r);if(o.ai.length)h=r+u+o.id.length+o.ai.length;else{h=n.indexOf(e.startAI,r+1);if(h<0){if(r+o.ai.max+o.id.length+u<n.length)throw new Error("Separators are required after variable length identifiers");h=n.length}}s.value=n.substring(r,h).replace(i,"");e.validate(o,s.value);a.pushData(s,e.dependentStates);if(h>=n.length)break;r=h;if(s.state!=e.startState){a[e.startState].move(s);s.state=e.startState}if(!o.ai.length)a.addPattern(e.START)}t.index=t.value.length},validate:function(t,e){var a=e.substr(t.id.length),n=t.ai;if(!n.type&&!x.test(a))throw new Error("Application identifier "+t.id+" is numeric only but contains non numeric character(s).");if(n.type=="alphanumeric"&&!k.test(a))throw new Error("Application identifier "+t.id+" is alphanumeric only but contains non alphanumeric character(s).");if(n.length&&n.length!==a.length)throw new Error("Application identifier "+t.id+" must be "+n.length+" characters long.");if(n.min&&n.min>a.length)throw new Error("Application identifier "+t.id+" must be at least "+n.min+" characters long.");if(n.max&&n.max<a.length)throw new Error("Application identifier "+t.id+" must be at most "+n.max+" characters long.")},getByLength:function(t,e){var a=this,n,i;for(var r=2;r<=4;r++){n=y(t,e,r);i=a.getAI(n)||a.getAI(n.substring(0,n.length-1));if(i)return{id:n,ai:i}}a.unsupportedAIError(n)},unsupportedAIError:function(t){throw new Error(e.format("'{0}' is not a supported Application Identifier"),t)},getBySeparator:function(t,e){var a=this,n=t.indexOf(a.startAI,e),i=t.indexOf(a.endAI,n),r=t.substring(n+1,i),s=a.getAI(r)||a.getAI(r.substr(r.length-1));if(!s)a.unsupportedAIError(r);return{ai:s,id:r}},getAI:function(t){var e=this.applicationIdentifiers,a=e.multiKey;if(e[t])return e[t];for(var n=0;n<a.length;n++)if(a[n].ids&&o(t,a[n].ids)>=0)return a[n].type;else if(a[n].ranges){var i=a[n].ranges;for(var r=0;r<i.length;r++)if(i[r][0]<=t&&t<=i[r][1])return a[n].type}},applicationIdentifiers:{22:{max:29,type:"alphanumeric"},402:{length:17},7004:{max:4,type:"alphanumeric"},242:{max:6,type:"alphanumeric"},8020:{max:25,type:"alphanumeric"},703:{min:3,max:30,type:"alphanumeric"},8008:{min:8,max:12,type:"alphanumeric"},253:{min:13,max:17,type:"alphanumeric"},8003:{min:14,max:30,type:"alphanumeric"},multiKey:[{ids:["15","17","8005","8100"],ranges:[[11,13],[310,316],[320,336],[340,369]],type:{length:6}},{ids:["240","241","250","251","400","401","403","7002","8004","8007","8110"],ranges:[[90-99]],type:{max:30,type:"alphanumeric"}},{ids:["7001"],ranges:[[410,414]],type:{length:13}},{ids:["10","21","254","420","8002"],type:{max:20,type:"alphanumeric"}},{ids:["00","8006","8017","8018"],type:{length:18}},{ids:["01","02","8001"],type:{length:14}},{ids:["422"],ranges:[[424,426]],type:{length:3}},{ids:["20","8102"],type:{length:2}},{ids:["30","37"],type:{max:8,type:"alphanumeric"}},{ids:["390","392"],type:{max:15,type:"alphanumeric"}},{ids:["421","423"],type:{min:3,max:15,type:"alphanumeric"}},{ids:["391","393"],type:{min:3,max:18,type:"alphanumeric"}},{ids:["7003","8101"],type:{length:10}}]},START:102}),a.extend({init:function(t){a.fn.init.call(this,t);this._initStates()},_initStates:function(){var t=this;for(var e=0;e<t.states.length;e++)t[t.states[e]]=new r[t.states[e]](t,t.states)},initValue:function(t,e,a){var n=this;n.pattern=[];n.value=t;n.width=e;n.height=a;n.checkSum=0;n.totalUnits=0;n.index=0;n.position=1},addData:function(){var t=this,e={value:t.value,index:0,state:""};if(t.value.length===0)return;e.state=e.previousState=t.getNextState(e,t.states);t.addStart(e);t.pushData(e,t.states);t.addCheckSum();t.addStop();t.setBaseUnit()},pushData:function(t,e){var a=this;while(true){a[t.state].pushState(t);if(t.index>=t.value.length)break;if(!t.shifted){t.previousState=t.state;t.state=a.getNextState(t,e);a[t.state].move(t)}else{var n=t.state;t.state=t.previousState;t.previousState=n;t.shifted=false}}},addStart:function(t){this[t.state].addStart(t);this.position=1},addCheckSum:function(){var t=this;t.checksum=t.checkSum%103;t.addPattern(t.checksum)},addStop:function(){this.addPattern(this.STOP)},setBaseUnit:function(){var t=this;t.baseUnit=t.width/(t.totalUnits+t.quietZoneLength)},addPattern:function(t){var e=this,a=e.characterMap[t].toString(),n;for(var i=0;i<a.length;i++){n=parseInt(a.charAt(i),10);e.pattern.push(n);e.totalUnits+=n}e.checkSum+=t*e.position++},getNextState:function(t,e){for(var a=0;a<e.length;a++)if(this[e[a]].is(t.value,t.index))return e[a];this.invalidCharacterError(t.value.charAt(t.index))},characterMap:[212222,222122,222221,121223,121322,131222,122213,122312,132212,221213,221312,231212,112232,122132,122231,113222,123122,123221,223211,221132,221231,213212,223112,312131,311222,321122,321221,312212,322112,322211,212123,212321,232121,111323,131123,131321,112313,132113,132311,211313,231113,231311,112133,112331,132131,113123,113321,133121,313121,211331,231131,213113,213311,213131,311123,311321,331121,312113,312311,332111,314111,221411,431111,111224,111422,121124,121421,141122,141221,112214,112412,122114,122411,142112,142211,241211,221114,413111,241112,134111,111242,121142,121241,114212,124112,124211,411212,421112,421211,212141,214121,412121,111143,111341,131141,114113,114311,411113,411311,113141,114131,311141,411131,211412,211214,211232,2331112],STOP:106})),I=(i.code128a=t.extend({name:"Code 128 A",states:["A"]}),i.code128b=t.extend({name:"Code 128 B",states:["B"]}),i.code128c=t.extend({name:"Code 128 C",states:["C"]}),i.code128=t.extend({name:"Code 128",states:["C","B","A","FNC4"]}),i["gs1-128"]=t.extend({name:"Code GS1-128",states:["FNC1","C","B"]}),a.extend({initValue:function(t,e){var a=this;a.pattern=[];a.value=t;a.checkSumLength=0;a.width=e},setBaseUnit:function(){var t=this,e=7;t.baseUnit=t.width/(12*(t.value.length+t.checkSumLength)+t.quietZoneLength+e)},addData:function(){var t=this,e=t.value;t.addPattern(t.START);for(var a=0;a<e.length;a++)t.addCharacter(e.charAt(a));if(t.options.addCheckSum)t.addCheckSum();t.addPattern(t.STOP);t.setBaseUnit()},addCharacter:function(t){var e=this,a=e.characterMap[t];if(!a)e.invalidCharacterError(t);e.addPattern(a)},addPattern:function(t){for(var e=0;e<t.length;e++)this.pattern.push(parseInt(t.charAt(e),10))},addCheckSum:function(){var t=this,e=t.checkSums[t.checkSumType],a;a=e.call(t.checkSums,t.value);t.checksum=a.join("");for(var n=0;n<a.length;n++){t.checkSumLength++;t.addPattern(t.characterMap[a[n]])}},checkSums:{Modulo10:function(t){var e=[0,""],a=t.length%2,n,i,r;for(n=0;n<t.length;n++)e[(n+a)%2]+=parseInt(t.charAt(n),10);r=e[0];i=(e[1]*2).toString();for(n=0;n<i.length;n++)r+=parseInt(i.charAt(n),10);return[(10-r%10)%10]},Modulo11:function(t){var e=0,a=11,n=t.length,i,r;for(var s=0;s<n;s++){i=((n-s)%6||6)+1;e+=i*t.charAt(s)}r=(a-e%a)%a;if(r!=10)return[r];return[1,0]},Modulo11Modulo10:function(t){var e=this.Modulo11(t),a;a=t+e[0];return e.concat(this.Modulo10(a))},Modulo10Modulo10:function(t){var e=this.Modulo10(t),a;a=t+e[0];return e.concat(this.Modulo10(a))}},characterMap:["12121212","12121221","12122112","12122121","12211212","12211221","12212112","12212121","21121212","21121221"],START:"21",STOP:"121",checkSumType:""})),_=(i.msimod10=I.extend({name:"MSI Modulo10",checkSumType:"Modulo10"}),i.msimod11=I.extend({name:"MSI Modulo11",checkSumType:"Modulo11"}),i.msimod1110=I.extend({name:"MSI Modulo11 Modulo10",checkSumType:"Modulo11Modulo10"}),i.msimod1010=I.extend({name:"MSI Modulo10 Modulo10",checkSumType:"Modulo10Modulo10"}),i.code11=a.extend({name:"Code 11",cCheckSumTotal:10,kCheckSumTotal:9,kCheckSumMinLength:10,checkSumMod:11,DASH_VALUE:10,DASH:"-",START:"112211",STOP:"11221",initValue:function(t,e){var a=this;a.pattern=[];a.value=t;a.width=e;a.totalUnits=0},addData:function(){var t=this;var e=t.value;t.addPattern(t.START);for(var a=0;a<e.length;a++)t.addCharacter(e.charAt(a));if(t.options.addCheckSum)t.addCheckSum();t.addPattern(t.STOP);t.setBaseUnit()},setBaseUnit:function(){var t=this;t.baseUnit=t.width/(t.totalUnits+t.quietZoneLength)},addCheckSum:function(){var t=this,e=t.value,a=e.length,n;n=t.getWeightedSum(e,a,t.cCheckSumTotal)%t.checkSumMod;t.checksum=n+"";t.addPattern(t.characterMap[n]);a++;if(a>=t.kCheckSumMinLength){var i=(n+t.getWeightedSum(e,a,t.kCheckSumTotal))%t.checkSumMod;t.checksum+=i;t.addPattern(t.characterMap[i])}},getWeightedSum:function(t,e,a){var n=0;for(var i=0;i<t.length;i++)n+=this.weightedValue(this.getValue(t.charAt(i)),e,i,a);return n},weightedValue:function(t,e,a,n){var i=(e-a)%n||n;return i*t},getValue:function(t){var e=this;if(!isNaN(t))return parseInt(t,10);else if(t!==e.DASH)e.invalidCharacterError(t);return e.DASH_VALUE},addCharacter:function(t){var e=this,a=e.getValue(t),n=e.characterMap[a];e.addPattern(n)},addPattern:function(t){var e;for(var a=0;a<t.length;a++){e=parseInt(t.charAt(a),10);this.pattern.push(e);this.totalUnits+=e}},characterMap:["111121","211121","121121","221111","112121","212111","122111","111221","211211","211111","112111"],options:{addCheckSum:true}}),i.postnet=a.extend({name:"Postnet",START:"2",VALID_CODE_LENGTHS:[5,9,11],DIGIT_SEPARATOR:"-",initValue:function(t,e,a){var n=this;n.height=a;n.width=e;n.baseHeight=a/2;n.value=t.replace(new RegExp(n.DIGIT_SEPARATOR,"g"),"");n.pattern=[];n.validate(n.value);n.checkSum=0;n.setBaseUnit()},addData:function(){var t=this,e=t.value;t.addPattern(t.START);for(var a=0;a<e.length;a++)t.addCharacter(e.charAt(a));if(t.options.addCheckSum)t.addCheckSum();t.addPattern(t.START);t.pattern.pop()},addCharacter:function(t){var e=this,a=e.characterMap[t];e.checkSum+=parseInt(t,10);e.addPattern(a)},addCheckSum:function(){var t=this;t.checksum=(10-t.checkSum%10)%10;t.addCharacter(t.checksum)},setBaseUnit:function(){var t=this,e=3;t.baseUnit=t.width/((t.value.length+1)*10+e+t.quietZoneLength)},validate:function(t){var e=this;if(!x.test(t))e.invalidCharacterError(t.match(/[^0-9]/)[0]);if(o(t.length,e.VALID_CODE_LENGTHS)<0)throw new Error("Invalid value length. Valid lengths for the Postnet symbology are "+e.VALID_CODE_LENGTHS.join(","))},addPattern:function(t){var e=this,a;for(var n=0;n<t.length;n++){a=e.height-e.baseHeight*t.charAt(n);e.pattern.push({width:1,y1:a,y2:e.height});e.pattern.push(1)}},characterMap:["22111","11122","11212","11221","12112","12121","12211","21112","21121","21211"]}),i.ean13=a.extend({initValue:function(t,e,a){t+="";if(t.length!=12||/\D/.test(t))throw new Error('The value of the "EAN13" encoding should be 12 symbols');var n=this;n.pattern=[];n.options.height=a;n.baseUnit=e/(95+n.quietZoneLength);n.value=t;n.checksum=n.calculateChecksum();n.leftKey=t[0];n.leftPart=t.substr(1,6);n.rightPart=t.substr(7)+n.checksum},addData:function(){var t=this;t.addPieces(t.characterMap.start);t.addSide(t.leftPart,t.leftKey);t.addPieces(t.characterMap.middle);t.addSide(t.rightPart);t.addPieces(t.characterMap.start)},addSide:function(t,e){var a=this;for(var n=0;n<t.length;n++)if(e&&parseInt(a.keyTable[e].charAt(n),10))a.addPieces(Array.prototype.slice.call(a.characterMap.digits[t.charAt(n)]).reverse(),true);else a.addPieces(a.characterMap.digits[t.charAt(n)],true)},addPieces:function(t,e){var a=this;for(var n=0;n<t.length;n++)if(e)a.pattern.push({y1:0,y2:a.options.height*.95,width:t[n]});else a.pattern.push(t[n])},calculateChecksum:function(){var t=0,e=0,a=this.value.split("").reverse().join("");for(var n=0;n<a.length;n++)if(n%2)e+=parseInt(a.charAt(n),10);else t+=parseInt(a.charAt(n),10);var i=(10-(3*t+e)%10)%10;return i},keyTable:["000000","001011","001101","001110","010011","011001","011100","010101","010110","011010"],characterMap:{digits:[[3,2,1,1],[2,2,2,1],[2,1,2,2],[1,4,1,1],[1,1,3,2],[1,2,3,1],[1,1,1,4],[1,3,1,2],[1,2,1,3],[3,1,1,2]],start:[1,1,1],middle:[1,1,1,1,1]}}),i.ean8=i.ean13.extend({initValue:function(t,e,a){var n=this;if(t.length!=7||/\D/.test(t))throw new Error("Invalid value provided");n.value=t;n.options.height=a;n.checksum=n.calculateChecksum(n.value);n.leftPart=n.value.substr(0,4);n.rightPart=n.value.substr(4)+n.checksum;n.pattern=[];n.baseUnit=e/(67+n.quietZoneLength)}}),u.extend({init:function(t,e){var a=this;u.fn.init.call(a,t,e);a.element=n(t);a.wrapper=a.element;a.element.addClass("k-barcode").css("display","block");a.surfaceWrap=n("<div />").css("position","relative").appendTo(this.element);a.surface=v.Surface.create(a.surfaceWrap,{type:a.options.renderAs});a._setOptions(e);if(e&&w(e.value))a.redraw()},setOptions:function(t){this._setOptions(t);this.redraw()},redraw:function(){var t=this._getSize();this.surface.clear();this.surface.setSize({width:t.width,height:t.height});this.createVisual();this.surface.draw(this.visual)},getSize:function(){return e.dimensions(this.element)},_resize:function(){this.redraw()},createVisual:function(){this.visual=this._render()},_render:function(){var t=this,e=t.options,a=e.value,n=e.text,d=f.getSpacing(n.margin),i=t._getSize(),c=e.border||{},r=t.encoding,s=new b(0,0,i.width,i.height).unpad(c.width).unpad(e.padding),o=s.height(),h,l,p;var u=new v.Group;t.contentBox=s;u.append(t._getBackground(i));if(n.visible){p=v.util.measureText(a,{font:n.font}).height;o-=p+d.top+d.bottom}h=r.encode(a,s.width(),o);if(n.visible){l=a;if(e.checksum&&w(r.checksum))l+=" "+r.checksum;u.append(t._getText(l))}t.barHeight=o;this._bandsGroup=this._getBands(h.pattern,h.baseUnit);u.append(this._bandsGroup);return u},exportVisual:function(){return this._render()},_getSize:function(){var t=this,e=t.element,a=new c.Size(S,C);if(e.width()>0)a.width=e.width();if(e.height()>0)a.height=e.height();if(t.options.width)a.width=t.options.width;if(t.options.height)a.height=t.options.height;return a},value:function(t){var e=this;if(!w(t))return e.options.value;e.options.value=t+"";e.redraw()},_getBands:function(t,e){var a=this,n=a.contentBox,i=n.x1,r,s;var o=new v.Group;for(var h=0;h<t.length;h++){s=p(t[h])?t[h]:{width:t[h],y1:0,y2:a.barHeight};r=s.width*e;if(h%2){var u=c.Rect.fromPoints(new c.Point(i,s.y1+n.y1),new c.Point(i+r,s.y2+n.y1));var d=v.Path.fromRect(u,{fill:{color:a.options.color},stroke:null});o.append(d)}i+=r}return o},_getBackground:function(t){var e=this,a=e.options,n=a.border||{};var i=new b(0,0,t.width,t.height).unpad(n.width/2);var r=v.Path.fromRect(i.toRect(),{fill:{color:a.background},stroke:{color:n.width?n.color:"",width:n.width,dashType:n.dashType}});return r},_getText:function(t){var e=this,a=e.options.text,n=e._textbox=new m(t,{font:a.font,color:a.color,align:"center",vAlign:"bottom",margin:a.margin});n.reflow(e.contentBox);n.renderVisual();return n.visual},_setOptions:function(t){var e=this;e.type=(t.type||e.options.type).toLowerCase();if(e.type=="upca"){e.type="ean13";t.value="0"+t.value}if(e.type=="upce"){e.type="ean8";t.value="0"+t.value}if(!i[e.type])throw new Error("Encoding "+e.type+"is not supported.");e.encoding=new i[e.type];e.options=d(true,e.options,t)},options:{name:"Barcode",renderAs:"svg",value:"",type:"code39",checksum:false,width:0,height:0,color:"black",background:"white",text:{visible:true,font:"16px Consolas, Monaco, Sans Mono, monospace, sans-serif",color:"black",margin:{top:0,bottom:0,left:0,right:0}},border:{width:0,dashType:"solid",color:"black"},padding:{top:0,bottom:0,left:0,right:0}}}));return f.ExportMixin.extend(_.fn),f.ui.plugin(_),e.deepExtend(f,{encodings:i,Encoding:a}),window.kendo})}("function"==typeof define&&define.amd?define:function(t,e,a){(a||e)()});
//# sourceMappingURL=kendo.dataviz.barcode.min.js.map
