﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;

namespace KSPortal.Resources
{
    /// <summary>
    /// třída pro práci s embedded soubory ve složce KSPortal\Resources
    /// </summary>
    public class KSResources
    {
        /// <summary>
        /// Funkce slouží k načítání embedded souborů ve složce KSPortal\Resources
        /// Soubor musí být součásti sestavení KSPortal ve složce Resources
        /// a musí u něj být nastaveno 
        /// Build Action: Embedded Resource
        /// Copy to Output Directory: Do not copy
        /// </summary>
        /// <param name="filename">název souboru i s příponou</param>
        /// <returns>pole bytů nebo null</returns>
        public static byte[] GetFile(string filename)
        {
            var assembly = System.Reflection.Assembly.GetExecutingAssembly();
            var resourceName = "KSPortal.Resources." + filename;

            using (Stream stream = assembly.GetManifestResourceStream(resourceName))
            {
                if (stream != null)
                {
                    using (var memoryStream = new MemoryStream())
                    {
                        stream.CopyTo(memoryStream);
                        return memoryStream.ToArray();
                    }
                }
            }

            return null;
        }
    }
}