﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZmppvInner.ascx.cs"
    Inherits="KSPortal.Controls.ZmppvInner" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="ZmppvInnerForm.ascx" TagName="ZmppvInnerForm" TagPrefix="uc1" %>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRB_ExportToPrint">
            <UpdatedControls>
            </UpdatedControls>
        </telerik:AjaxSetting>
                <telerik:AjaxSetting AjaxControlID="TRB_save">
                    <UpdatedControls>
                        <telerik:AjaxUpdatedControl ControlID="FormView1" />
                    </UpdatedControls>
                </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_send">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="FormView1" />
                <telerik:AjaxUpdatedControl ControlID="L_Verejnost_blokovana" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_send_email">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="FormView1" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<style type="text/css">
    div.zmppvZarovnatVlevo {
        margin-left: 0px !important;
    }

    div.rplInner {
    }

        div.rplInner > div > div > fieldset, div.rplInner > div > div > div > fieldset {
            margin: 0 0 10px 0;
            border-color: lightgray;
            border-style: solid;
            border-width: 1px;
        }

            div.rplInner > div > div > fieldset > legend, div.rplInner > div > div > div > fieldset > legend {
                font-size: 12px;
                color: #4f4f4f;
                font-weight: bold;
            }

    table.InnerTableForm > tbody > tr > td {
        padding: 5px;
        vertical-align: top;
    }

    tr.ppHeader > td {
        border-bottom: 1px solid;
        border-color: lightgray;
    }

    table.InnerTableFormFieldset {
        border-collapse: collapse !important;
    }

        table.InnerTableFormFieldset > tbody > tr > td, span.InnerTableFormFieldset {
            padding: 3px 5px 3px 5px;
        }

        table.InnerTableFormFieldset > tbody > tr > td {
            white-space: nowrap;
        }

    .povinne-pole {
        color: black !important;
    }

    table.oldValues > tbody > tr > td:nth-of-type(2) {
        border-left: 1px solid;
        border-right: 1px solid;
        border-color: lightgray;
    }

    .tdValidators {
        font-size: large;
        padding: 0px;
        margin: 0px;
        color: red;
    }

    .tableValidators {
        font-size: large;
        padding: 0px;
        margin: 0px;
        color: red;
        float: right;
    }

    .labelWidth {
        width: 120px;
    }

    .slideBar {
        position: fixed;
        top: 200px;
    }

    tr.newValue > td {
        background-color: lightsalmon !important;
    }

    .formsumary {
        padding-top: 5px;
        padding-bottom: 5px;
        display: -webkit-box;
    }

    .ksRgpriplatky .rgBatchContainer > .RadComboBox,
    .ksRgpriplatky .rgBatchContainer > .RadInput,
    .ksRgpriplatky .rgBatchContainer > .RadPicker,
    .ksRgdokumenty_p .rgBatchContainer > .RadComboBox,
    .ksRgdokumenty_p .rgBatchContainer > .RadInput,
    .ksRgdokumenty_p .rgBatchContainer > .RadPicker,
    .ksRgdokumenty_p .rgBatchContainer > .RadAsyncUpload {
        width: 100% !important;
    }



    .ks-cbMinWidth {
        min-width: 160px;
    }

    .ks-cbMinWidth200{
        min-width: 210px;
    }

    .ksRgpriplatky .rgBatchCurrent .rcTable.rcSingle {
            width: 100% !important;
        }
</style>
<asp:Panel ID="outer_panel" runat="server">
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" InsertMethod="Insert"
        OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekzmppv"
        OnInserted="ObjectDataSource1_Inserted" OnInserting="ObjectDataSource1_Inserting"
        OnUpdated="ObjectDataSource1_Updated"
        OnUpdating="ObjectDataSource1_Updating" UpdateMethod="Update">
        <InsertParameters>
            <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
            <asp:Parameter Name="typ_zadosti" Type="Int16" />
            <asp:Parameter Name="adresat" Type="Decimal" />
            <asp:Parameter Name="os_cislo" Type="Decimal" />
            <asp:Parameter Name="cislo_pom" Type="Int16" />
            <asp:Parameter Name="vyridit_do" Type="DateTime" />
            <asp:Parameter Name="duvod" Type="String" />
            <asp:Parameter Name="titul" Type="String" />
            <asp:Parameter Name="jmeno" Type="String" />
            <asp:Parameter Name="prijmeni" Type="String" />
            <asp:Parameter Name="titul_za" Type="String" />
            <asp:Parameter Name="rodne_cislo" Type="String" />
            <asp:Parameter Name="misto_narozeni" Type="String" />
            <asp:Parameter Name="rodin_stav" Type="String" />
            <asp:Parameter Name="deti_pro_duch" Type="Int16" />
            <asp:Parameter Name="st_prisl" Type="String" />
            <asp:Parameter Name="tr_ulice" Type="String" />
            <asp:Parameter Name="tr_cislo" Type="String" />
            <asp:Parameter Name="misto_trv" Type="String" />
            <asp:Parameter Name="psc_trv" Type="String" />
            <asp:Parameter Name="kmen_str" Type="String" />
            <asp:Parameter Name="datum_nastupu" Type="DateTime" />
            <asp:Parameter Name="plati_od" Type="DateTime" />
            <asp:Parameter Name="id_pracmist" Type="Int32" />
            <asp:Parameter Name="prac_str" Type="String" />
            <asp:Parameter Name="kmen_str_p" Type="String" />
            <asp:Parameter Name="druh_pom_j" Type="String" />
            <asp:Parameter Name="typ_mzdy" Type="Int16" />
            <asp:Parameter Name="trida" Type="Int16" />
            <asp:Parameter Name="mzd_stup" Type="Int16" />
            <asp:Parameter Name="tarif" Type="Decimal" />
            <asp:Parameter Name="pp_datum_nastupu" Type="DateTime" />
            <asp:Parameter Name="prac_kateg" Type="Int16" />
            <asp:Parameter Name="typ_kal" Type="Int16" />
            <asp:Parameter Name="hod_uvazek" Type="Decimal" />
            <asp:Parameter Name="zak_uvazek" Type="Decimal" />
            <asp:Parameter Name="smluv_pom_uv" Type="Decimal" />
            <asp:Parameter Name="doba_uvazku" Type="String" />
            <asp:Parameter Name="zk_doba" Type="DateTime" />
            <asp:Parameter Name="jkz" Type="Int32" />
            <asp:Parameter Name="duvod_nastupu" Type="String" />

            <asp:Parameter Type="String" Name="stat_adr" />
            <asp:Parameter Type="String" Name="trv_postcode" />
            <asp:Parameter Type="String" Name="pr_ulice" />
            <asp:Parameter Type="String" Name="pr_cislo" />
            <asp:Parameter Type="String" Name="misto_prech" />
            <asp:Parameter Type="String" Name="prech_stat_adr" />
            <asp:Parameter Type="String" Name="psc_prech" />
            <asp:Parameter Type="String" Name="prech_postcode" />
            <asp:Parameter Type="String" Name="rodne_jmeno" />
            <asp:Parameter Type="String" Name="vsechna_prij" />
            <asp:Parameter Type="String" Name="cislo_op" />
            <asp:Parameter Type="String" Name="cislo_pasu" />
            <asp:Parameter Type="String" Name="c_pov_pobytu" />
            <asp:Parameter Type="String" Name="vydal_povol_pobyt" />
            <asp:Parameter Type="String" Name="telefon" />
            <asp:Parameter Type="String" Name="email" />
            <asp:Parameter Type="String" Name="cislo_uctu" />
            <asp:Parameter Type="String" Name="kod_banky" />
            <asp:Parameter Type="String" Name="iban" />
            <asp:Parameter Type="String" Name="swift" />
            <asp:Parameter Type="String" Name="vzd_stupen" />
            <asp:Parameter Type="String" Name="vzd_obor" />
            <asp:Parameter Type="String" Name="rp" />
            <asp:Parameter Type="Int32" Name="exekuce" />
            <asp:Parameter Type="Int32" Name="postizeni" />
            <asp:Parameter Type="Int16" Name="zdrav_poj" />
            <asp:Parameter Type="String" Name="inv_stupen" />
            <asp:Parameter Type="DateTime" Name="inv_od" />
            <asp:Parameter Type="DateTime" Name="datum_skut_nast" />
            <asp:Parameter Type="DateTime" Name="datum_ukonc" />
            <asp:Parameter Type="Decimal" Name="os_hodn" />
            <asp:Parameter Type="Decimal" Name="prem_cast" />
            <asp:Parameter Type="Int32" Name="typ_premii" />
            <asp:Parameter Type="Decimal" Name="pripl_vedeni" />
            <asp:Parameter Type="Decimal" Name="pripl_zvlastni" />
        </InsertParameters>
        <SelectParameters>
            <asp:Parameter Name="id_pozadavku" Type="Int32" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="id_poz" Type="Int32" />
            <asp:Parameter Name="typ_zadosti" Type="Int16" />
            <asp:Parameter Name="adresat" Type="Decimal" />
            <asp:Parameter Name="os_cislo" Type="Decimal" />
            <asp:Parameter Name="cislo_pom" Type="Int16" />
            <asp:Parameter Name="vyridit_do" Type="DateTime" />
            <asp:Parameter Name="duvod" Type="String" />
            <asp:Parameter Name="titul" Type="String" />
            <asp:Parameter Name="jmeno" Type="String" />
            <asp:Parameter Name="prijmeni" Type="String" />
            <asp:Parameter Name="titul_za" Type="String" />
            <asp:Parameter Name="rodne_cislo" Type="String" />
            <asp:Parameter Name="misto_narozeni" Type="String" />
            <asp:Parameter Name="rodin_stav" Type="String" />
            <asp:Parameter Name="deti_pro_duch" Type="Int16" />
            <asp:Parameter Name="st_prisl" Type="String" />
            <asp:Parameter Name="tr_ulice" Type="String" />
            <asp:Parameter Name="tr_cislo" Type="String" />
            <asp:Parameter Name="misto_trv" Type="String" />
            <asp:Parameter Name="psc_trv" Type="String" />
            <asp:Parameter Name="kmen_str" Type="String" />
            <asp:Parameter Name="datum_nastupu" Type="DateTime" />
            <asp:Parameter Name="plati_od" Type="DateTime" />
            <asp:Parameter Name="id_pracmist" Type="Int32" />
            <asp:Parameter Name="prac_str" Type="String" />
            <asp:Parameter Name="kmen_str_p" Type="String" />
            <asp:Parameter Name="druh_pom_j" Type="String" />
            <asp:Parameter Name="typ_mzdy" Type="Int16" />
            <asp:Parameter Name="trida" Type="Int16" />
            <asp:Parameter Name="mzd_stup" Type="Int16" />
            <asp:Parameter Name="tarif" Type="Decimal" />
            <asp:Parameter Name="pp_datum_nastupu" Type="DateTime" />
            <asp:Parameter Name="prac_kateg" Type="Int16" />
            <asp:Parameter Name="typ_kal" Type="Int16" />
            <asp:Parameter Name="hod_uvazek" Type="Decimal" />
            <asp:Parameter Name="zak_uvazek" Type="Decimal" />
            <asp:Parameter Name="smluv_pom_uv" Type="Decimal" />
            <asp:Parameter Name="doba_uvazku" Type="String" />
            <asp:Parameter Name="zk_doba" Type="DateTime" />
            <asp:Parameter Name="jkz" Type="Int32" />
            <asp:Parameter Name="duvod_nastupu" Type="String" />

            <asp:Parameter Type="String" Name="stat_adr" />
            <asp:Parameter Type="String" Name="trv_postcode" />
            <asp:Parameter Type="String" Name="pr_ulice" />
            <asp:Parameter Type="String" Name="pr_cislo" />
            <asp:Parameter Type="String" Name="misto_prech" />
            <asp:Parameter Type="String" Name="prech_stat_adr" />
            <asp:Parameter Type="String" Name="psc_prech" />
            <asp:Parameter Type="String" Name="prech_postcode" />
            <asp:Parameter Type="String" Name="rodne_jmeno" />
            <asp:Parameter Type="String" Name="vsechna_prij" />
            <asp:Parameter Type="String" Name="cislo_op" />
            <asp:Parameter Type="String" Name="cislo_pasu" />
            <asp:Parameter Type="String" Name="c_pov_pobytu" />
            <asp:Parameter Type="String" Name="vydal_povol_pobyt" />
            <asp:Parameter Type="String" Name="telefon" />
            <asp:Parameter Type="String" Name="email" />
            <asp:Parameter Type="String" Name="cislo_uctu" />
            <asp:Parameter Type="String" Name="kod_banky" />
            <asp:Parameter Type="String" Name="iban" />
            <asp:Parameter Type="String" Name="swift" />
            <asp:Parameter Type="String" Name="vzd_stupen" />
            <asp:Parameter Type="String" Name="vzd_obor" />
            <asp:Parameter Type="String" Name="rp" />
            <asp:Parameter Type="Int32" Name="exekuce" />
            <asp:Parameter Type="Int32" Name="postizeni" />
            <asp:Parameter Type="Int16" Name="zdrav_poj" />
            <asp:Parameter Type="String" Name="inv_stupen" />
            <asp:Parameter Type="DateTime" Name="inv_od" />
            <asp:Parameter Type="DateTime" Name="datum_skut_nast" />
            <asp:Parameter Type="DateTime" Name="datum_ukonc" />
            <asp:Parameter Type="Decimal" Name="os_hodn" />
            <asp:Parameter Type="Decimal" Name="prem_cast" />
            <asp:Parameter Type="Int32"  Name="typ_premii"/>
            <asp:Parameter Type="Decimal" Name="pripl_vedeni" />
            <asp:Parameter Type="Decimal" Name="pripl_zvlastni" />
        </UpdateParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_rodin_stav" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisRodinnyStav">
        <SelectParameters>
            <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_typ_premii" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetCiselnik" TypeName="KSProgram.Ciselniky.CisMzdPol">
        <SelectParameters>
            <asp:Parameter DefaultValue="prac_pom_typ_premie" Name="agenda" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_st_prisl" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisStatniPrisl">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="pridat_prazdny_radek" Type="Boolean" />
            <asp:Parameter Name="nazev_format_string" Type="String" />
            <asp:Parameter Name="clen_eu" Type="Boolean" />
            <asp:Parameter Name="orderByPriorityRegions" Type="Boolean" DefaultValue="true" />
            <asp:Parameter DefaultValue="cesky" Name="order_by" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_stat" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisStatniPrisl" OnSelecting="ods_stat_Selecting">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="pridat_prazdny_radek" Type="Boolean" />
            <asp:Parameter DefaultValue="{kod_znakovy2} - {cesky}" Name="nazev_format_string" Type="String" />
            <asp:Parameter Name="clen_eu" Type="Boolean" />
            <asp:Parameter Name="orderByPriorityRegions" Type="Boolean" DefaultValue="true" />
            <asp:Parameter DefaultValue="kod_znakovy2" Name="order_by" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_zdrav_poj" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisOsoby" OnSelecting="ODS_osoby_Selecting">
        <SelectParameters>
            <asp:Parameter DefaultValue="zp" Name="typOsoby" Type="String" />
            <asp:Parameter Name="id_podniku" Type="Int32" />
            <asp:Parameter Name="distinct" Type="Boolean" DefaultValue="true"/>
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_kod_banky" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisOsoby" OnSelecting="ODS_osoby_Selecting">
        <SelectParameters>
            <asp:Parameter DefaultValue="ba" Name="typOsoby" Type="String" />
            <asp:Parameter Name="id_podniku" Type="Int32" />
            <asp:Parameter DefaultValue="nazev,c_pole1" Name="pole" Type="String" />
            <asp:Parameter DefaultValue="{c_pole1} - {nazev}" Name="cely_nazev_format_string" Type="String" />
            <asp:Parameter DefaultValue="c_pole1" Name="order_by" Type="String" />
            <asp:Parameter DefaultValue="c_pole1 IS NOT NULL" Name="where" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_swift" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisOsoby" OnSelecting="ODS_osoby_Selecting">
        <SelectParameters>
            <asp:Parameter DefaultValue="ba" Name="typOsoby" Type="String" />
            <asp:Parameter Name="id_podniku" Type="Int32" />
            <asp:Parameter DefaultValue="nazev,c_pole2" Name="pole" Type="String" />
            <asp:Parameter DefaultValue="{c_pole2} - {nazev}" Name="cely_nazev_format_string" Type="String" />
            <asp:Parameter DefaultValue="c_pole2" Name="order_by" Type="String" />
            <asp:Parameter DefaultValue="c_pole2 IS NOT NULL" Name="where" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_stupen" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="StupenSeznam" TypeName="KSProgram.Ciselniky.CisVzdelani"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_obor" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="OborSeznam" TypeName="KSProgram.Ciselniky.CisVzdelani">
        <SelectParameters>
            <asp:Parameter DefaultValue="ORDER BY vyznam" Name="expression_OrderBy" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_duchod" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetData" TypeName="KSProgram.Ciselniky.CisInvalidita"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_kmen_str" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="VsechnaPracStrediska" TypeName="KSProgram.Ciselniky.CisStredisko">
        <SelectParameters>
            <asp:Parameter DefaultValue="" Name="datum" Type="DateTime" />
            <asp:Parameter DefaultValue="True" Name="ab_prazdny" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_prac_mista" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="SeznamPM" TypeName="KSProgram.PracovniMista.PracMista" OnSelecting="ods_prac_mista_Selecting">
        <SelectParameters>
            <asp:Parameter Type="Int32" Name="systemove_typy" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_druh_pom" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisDruhPom">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_typ_mzdy" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisTypMzdy">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <%--<asp:ObjectDataSource ID="ods_misto_vykonu" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Ciselnik" TypeName="KSProgram.Ciselniky.CisObci">misto vykonu neni z ciselniku obci
    </asp:ObjectDataSource>--%>
    <asp:ObjectDataSource ID="ods_prac_kateg" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisPracKateg">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_typ_kal" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="SeznamTypKalendare" TypeName="KSProgram.Ciselniky.CisPracRozvrh">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
            <asp:Parameter DefaultValue="1,2,4,5,6,7,9" Name="typy" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_doba_uvazku" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisUniv">
        <SelectParameters>
            <asp:Parameter DefaultValue="22" Name="id" Type="Int16" />
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_skup_prac" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisUniv">
        <SelectParameters>
            <asp:Parameter DefaultValue="21" Name="id" Type="Int16" />
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_kzam" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisKzam">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ods_duvod_nast" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="SeznamDuvoduNastupuVystupu" TypeName="KSProgram.Ciselniky.CisDuvodNastVyst">
        <SelectParameters>
            <asp:Parameter DefaultValue="true" Name="nastupy" Type="Boolean" />
            <asp:Parameter DefaultValue="false" Name="vystupy" Type="Boolean" />
            <asp:Parameter DefaultValue="false" Name="pridatPrazdnyRadek" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_kody_priplatky" runat="server"
        SelectMethod="GetCiselnik" TypeName="KSProgram.Ciselniky.CisMzdPol">
        <SelectParameters>
            <asp:Parameter DefaultValue="priplatky" Name="agenda" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_dokumenty_p" runat="server"
        SelectMethod="Retrieve" TypeName="KSProgram.Ciselniky.CisDruhyDokumentu">
        <SelectParameters>
            <asp:Parameter Name="pridatPrazdnyRadek" DefaultValue="true" Type="String" />
            <asp:Parameter Name="jenWFNovyZam" DefaultValue="true" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <telerik:RadCodeBlock ID="RCB_outer" runat="server">
        <script type="text/javascript" id="rcbs_outer">
            //<![CDATA[
            function GetFVServerElement(serverID, tagName, getMetot) {
                if (!tagName)
                    tagName = "*"; //* means all elements 

                var grid = document.getElementById("<%=FormView1.ClientID %>");
                var elements = grid.getElementsByTagName(tagName);
                for (var i = 0; i < elements.length; i++) {
                    var element = elements[i];
                    if (element.id.indexOf(serverID) >= 0) {
                        var ret = null;
                        if (!getMetot || getMetot == "find") {

                            ret = $find(element.id);
                        }
                        else {
                            ret = $get(element.id);
                        }
                        if (ret) {
                            return ret;
                        }
                    }
                }
                return null;
            }
            function TRCB_edit_os_cislo_ItemsRequesting(sender, args) {
                var context = args.get_context();
                context["UsePrava"] = true;
            }
            function RNTB_e_hod_uvazek_OnValueChanged(sender, args) {
                if (parseFloat(args.get_newValue().replace(",", ".")) > 12)
                    sender.set_value(parseFloat(args.get_newValue().replace(",", ".")) / 5);
            }
            function RNTB_e_smluv_pom_uv_OnValueChanged(sender, args) {
                debugger;

                var smluv_pom_uv = parseFloat(args.get_newValue().replace(",", "."));

                if (Number.isNaN(smluv_pom_uv)) {
                    smluv_pom_uv = parseFloat(args.get_oldValue().replace(",", "."));
                    smluv_pom_uv = Number.isNaN(smluv_pom_uv) ? 1 : smluv_pom_uv;
                    args.set_cancel();
                    sender.set_value(smluv_pom_uv);
                }

                var zak_uvazek = GetFVServerElement('RNTB_e_zak_uvazek', 'input', 'find')?.get_value();

                var new_hod_uvazek = Math.round(smluv_pom_uv * zak_uvazek * 100) / 100 ;

                var RNTB_hod_uvazek = GetFVServerElement('RNTB_e_hod_uvazek', 'input', 'find');

                var hod_uvazek = RNTB_hod_uvazek.get_value();

                if (hod_uvazek != new_hod_uvazek) {
                    radconfirm(`Má se do skutečného úvazku zapsat hodnota spočtená dle zákonného úvazku, tzn.: ${new_hod_uvazek}`,
                        function (arg) {
                            if (arg) {
                                RNTB_hod_uvazek.set_value(new_hod_uvazek);
                            }
                        }, 0, 0, sender, 'Skutečný úvazek'
                    );
                }
            }
            function psc_ItemsRequesting(sender, args) {
                var context = args.get_context();
                var name;
                if (sender._uniqueId.indexOf("_edit_psc_prech") >= 0) {
                    name = "TRCB_edit_misto_prech";
                }
                else {
                    name = "TRCB_edit_obec";
                }
                var cb_obec = GetFVServerElement(name, null, "find");
                var val = "";
                if (cb_obec.get_text() != cb_obec.get_emptyMessage()) {
                    val = cb_obec.get_text();
                }
                context["obec"] = val;
            }
            function obec_ItemsRequesting(sender, args) {
                var context = args.get_context();
                var name;
                if (sender._uniqueId.indexOf("_edit_misto_prech") >= 0) {
                    name = "TRCB_edit_psc_prech";
                }
                else {
                    name = "TRCB_edit_psc";
                }
                var cb_psc = GetFVServerElement(name, null, "find");
                var val = "";
                if (cb_psc.get_text() != cb_psc.get_emptyMessage()) {
                    val = cb_psc.get_text();
                }
                context["psc"] = val;
            }
            function TRCB_psc_obec_DropDownClosed(sender, args) {
                sender.clearItems();
            }

            function TRDP_edit_datum_nast_OnDateSelected(sender, args) {
                var name = "TRDP_e_pp_datum_nastupu";
                var dat_nast = GetFVServerElement(name, "input", "find");

                var datum = sender.get_selectedDate();

                if (datum && dat_nast) {
                    dat_nast.clear();
                    dat_nast.set_selectedDate(datum);
                }
            }
            function TRDP_i_datum_nastupu_OnDateSelected(sender, args) {
                var name = "TRDP_e_zk_doba";
                var zk_doba = GetFVServerElement(name, "input", "find");

                var name2 = "TRDP_e_datum_skut_nast";
                var skut_nastup = GetFVServerElement(name2, "input", "find");

                var datum = sender.get_selectedDate();

                if (datum) {
                    zk_doba.clear();
                    zk_doba.set_minDate(datum);
                    skut_nastup.set_selectedDate(datum);

                    datum.setMonth(datum.getMonth() + 3);
                    var jedenden = (24 * 60 * 60 * 1000); //1 day
                    datum.setTime(datum.getTime() - jedenden);

                    zk_doba.set_selectedDate(datum);
                }
            }

            function TRB_e_datum_ukonc_m_Clicked(sender, args) {
                var m = args.get_commandArgument();
                var nastup = GetFVServerElement("TRDP_e_pp_datum_nastupu", "input", "find");
                var nastup_old = GetFVServerElement("HF_pp_datum_nastupu_old", "input", "get");
                var ukonc = GetFVServerElement("TRDP_e_datum_ukonc", "input", "find");
                var ukonc_old = GetFVServerElement("HF_datum_ukonc_old", "input", "get");
                var jedenden = (24 * 60 * 60 * 1000); //1 day

                var datum_nastup = null;
                if (nastup)
                    var datum_nastup = nastup.get_selectedDate();

                var old_datum_nastup = null;
                var parts = nastup_old.value.split(".");
                if (parts.length >= 3) {
                    old_datum_nastup = new Date(parseInt(parts[2], 10),
                        parseInt(parts[1], 10) - 1,
                        parseInt(parts[0], 10));
                }

                var old_datum_vystup = null;
                parts = ukonc_old.value.split(".");
                if (parts.length >= 3) {
                    old_datum_vystup = new Date(parseInt(parts[2], 10),
                        parseInt(parts[1], 10) - 1,
                        parseInt(parts[0], 10));
                    old_datum_vystup.setTime(old_datum_vystup.getTime() + jedenden);
                }

                var datum = old_datum_vystup ? old_datum_vystup : (datum_nastup ? datum_nastup : old_datum_nastup);
                if (datum && ukonc) {
                    datum.setMonth(datum.getMonth() + Number(m));
                    datum.setTime(datum.getTime() - jedenden);
                    ukonc.set_selectedDate(datum);
                }
            }

            function TRDP_datum_ukonc_di_ValueChanged(sender, args) {
                var datum_ukonc = args.get_newDate();
                var nastup = GetFVServerElement("TRDP_e_pp_datum_nastupu", "input", "find");
                var nastup_old = GetFVServerElement("HF_pp_datum_nastupu_old", "input", "get");
                var uvazek = GetFVServerElement("TRCB_e_doba_uvazku", "div", "find");
                if (nastup && uvazek) {
                    var datum_nastup = nastup.get_selectedDate();
                    var old_datum = null;
                    var parts = nastup_old.value.split(".");
                    if (parts.length >= 3) {
                        old_datum = new Date(parseInt(parts[2], 10),
                            parseInt(parts[1], 10) - 1,
                            parseInt(parts[0], 10));
                    }
                    datum_nastup = datum_nastup ? datum_nastup : old_datum;
                    if (datum_nastup) {
                        if (datum_ukonc) {
                            var rozdil = datum_ukonc - datum_nastup;
                            // asi nic nenastavovat
                        }
                        else {
                            var comboItem = uvazek.findItemByValue("1");
                            if (comboItem)
                                comboItem.select();
                        }
                    }
                }
            }

            // přepsání funkce v KSMaster, která je volána z PozadavekDetail.aspx
            var oldPozadavekSaveClicking = !oldPozadavekSaveClicking ? KSMaster.onPozadavekSaveClicking : oldPozadavekSaveClicking;
            KSMaster.onPozadavekSaveClicking = function (sender, args) {
                oldPozadavekSaveClicking.apply(sender, args);

                checkErrors(sender, args);
            };
            KSMaster.onPozadavekSaveClicking.prototype = oldPozadavekSaveClicking.prototype;

            function checkErrors(sender, args) {
                var vals = Page_Validators;
                for (i = 0; i < vals.length; i++) {
                    if (vals[i].classList.contains('ksDisabledVal')) {
                        ValidatorEnable(vals[i], true);
                        vals[i].classList.remove('ksDisabledVal');
                    }
                }
                var isValid = Page_ClientValidate('');
                if (!isValid) {
                    var RW_Errors = $find('<%= RW_Errors.ClientID %>');
                    RW_Errors.show();
                    RW_Errors.autoSize();
                }
            }

            function checkFormats(sender, args) {
                var isValid = true;
                var vals = Page_Validators;
                for (i = 0; i < vals.length; i++) {
                    if (vals[i].classList.contains('formatValidator')) {
                        isValid = isValid && vals[i].isvalid;
                    }
                    else if (!vals[i].isvalid) {
                        ValidatorEnable(vals[i], false);
                        vals[i].isvalid = true;
                        vals[i].classList.add('ksDisabledVal');
                    }
                }
                Page_ClientValidate('');
                if (!isValid) {
                    var RW_Errors = $find('<%= RW_Errors.ClientID %>');
                    RW_Errors.show();
                    RW_Errors.autoSize();
                }
            }

            function RW_Errors_close(sender, args) {
                var RW_Errors = $find('<%= RW_Errors.ClientID %>');
                RW_Errors.close();
            }

            function rc_validate(source, arguments) {
                var val = arguments.Value;

                if (val === '000000 / 000' || KSValidator.validateRodneCislo(val)) {
                    arguments.IsValid = true;
                }
                else {
                    arguments.IsValid = false;
                }
            }

            function rc_is_not_empty(source, arguments) {
                arguments.IsValid = arguments.Value !== '000000 / 000';
            }

            function is_rc_unique(source, arguments) {
                var valid = false;
                var val = arguments.Value;
                var d = [];
                var item = { "rc": val };
                d.push(item);
                item = { "id_podniku": <%=IdPodniku %> };
                d.push(item);
                var data_send = JSON.stringify(d);
                $.ajax({
                    type: "POST",
                    url: "../Public/NovyZamUdaje.aspx/rcIsUnique",
                    data: "{data:'" + data_send + "'}",
                    async: false,
                    contentType: "application/json",
                    dataType: "json",
                    error: function (xhr, ajaxOptions, thrownError) {
                        KSMaster.showError(xhr.responseText, xhr.status);
                    },
                    success: function (msg) {
                        valid = msg.d.je_unikatni === "True"
                    }
                });
                arguments.IsValid = valid;
            }

            function cislo_uctu_validate(source, arguments) {
                arguments.IsValid = KSValidator.validateCisloUctu(arguments.Value);
            }

            function iban_validate(source, arguments) {
                arguments.IsValid = KSValidator.validateIban(arguments.Value);
            }

            function email_validate(source, arguments) {
                arguments.IsValid = KSValidator.validateEmail(arguments.Value);
            }

            var stoprequesting = false;
            var requestfromopening = false;
            function dropDownOpening(sender, args) {
                requestfromopening = true;
                stoprequesting = false;
                sender.requestItems('', false);
                stoprequesting = true;
            }
            function dropDownItemsRequesting(sender, args) {
                if (requestfromopening) {
                    if (stoprequesting) {
                        stoprequesting = false;
                        requestfromopening = false;
                        sender._filterText = '';
                        args.set_cancel(true);
                    }
                }
            }
            function dropDownTextChange(sender, args) {
                requestfromopening = false;
            }

            function GCIC_pripl_add(sender, args) {
                var mtv = $find(sender.get_element().closest(".rgMasterTable").id);
                mtv.fireCommand("InitInsert", "");
            }

            function TRG_priplatky_BatchEditOpened(sender, args) {
                if (args.get_columnUniqueName() == "kod") {
                    $get(args.get_cell().getElementsByClassName("RadComboBox")[0].id + "_DropDown").classList.add("ks-cbMinWidth");
                }
            }

            //function TRG_dokumenty_BatchEditOpened(sender, args) {
            //    if (args.get_columnUniqueName() == "typ_dokumentu") {
            //        $get(args.get_cell().getElementsByClassName("RadComboBox")[0].id + "_DropDown").classList.add("ks-cbMinWidth");
            //    }
            //}

            function TRG_priplatky_CellValueChanging(sender, args) {
                sender.get_element().getElementsByClassName("ks_saveButton")[0].classList.remove("hidden");
            }

            function removeClassHidden(sender, args) {
                removeClass(sender, 'hidden');
            }
            function removeClassPovinne(sender, args) {
                removeClass(sender, 'povinne-pole');
            }
            function removeClassPovinneHidden(sender, args) {
                removeClass(sender, 'hidden');
                removeClass(sender, 'povinne-pole');
            }
            function removeClass(sender, trida) {
                if (sender.removeCssClass) {
                    sender.removeCssClass(trida);
                }
                if (sender._textBoxElement) {
                    sender._textBoxElement.className.replace(' ' + trida, '');
                }
                if (sender.get_styles) {
                    var styles = sender.get_styles();
                    for (s in styles) {
                        if (styles[s].length > 1) {
                            styles[s][1] = styles[s][1].replace(' ' + trida, '');
                        }
                    }
                }
            }


        //]]>
        </script>
    </telerik:RadCodeBlock>
    <kspwc:TFormView ID="FormView1" runat="server" Width="100%"
        OnModeChanged="FormView1_ModeChanged" OnModeChanging="FormView1_ModeChanging"
        DataSourceID="ObjectDataSource1" OnItemInserted="FormView1_ItemInserted" OnItemUpdated="FormView1_ItemUpdated"
        OnDataBound="FormView1_DataBound">
        <EditItemTemplate>
            <uc1:ZmppvInnerForm runat="server" ID="ZmppvInnerForm_e" />
        </EditItemTemplate>
        <HeaderStyle CssClass="rgCaption" />
        <InsertItemTemplate>
            <uc1:ZmppvInnerForm runat="server" ID="ZmppvInnerForm_i" />
        </InsertItemTemplate>
        <ItemTemplate>
            <uc1:ZmppvInnerForm runat="server" ID="ZmppvInnerForm_r" />
            <asp:Panel ID="readOnlyHolder" runat="server"></asp:Panel>
        </ItemTemplate>
        <FooterTemplate>
            <telerik:RadPageLayout runat="server" ID="RPL" GridType="Fluid" CssClass="rplInnerF">
                <Rows>
                    <telerik:LayoutRow>
                        <Columns>
                            <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                                <kspwc:TRadButton runat="server" ID="TRB_ExportToPrint" Text="[%Tisk%]" OnClick="TRB_Print_Click" Visible="false" CausesValidation="false"></kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_send_email" Text="[%Znovu odeslat e-mail uchazeči%]" Visible="false" CausesValidation="false" OnClick="TRB_send_email_Click"></kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_save" Text="[%Uložit%]" OnClick="TRB_save_Click" Visible="false" OnClientClicking="checkFormats"></kspwc:TRadButton>
                                <kspwc:TRadButton runat="server" ID="TRB_send" Text="[%Uložit a odeslat%]" OnClick="TRB_send_Click" Visible="false" OnClientClicking="checkErrors"></kspwc:TRadButton>
                            </telerik:LayoutColumn>
                        </Columns>
                    </telerik:LayoutRow>
                </Rows>
            </telerik:RadPageLayout>
        </FooterTemplate>
    </kspwc:TFormView>
    <asp:Label runat="server" ID="L_Verejnost_blokovana" Text="[%Údaje jsou zpracovávány. V této chvíli nemáte právo prohlížet data žádosti o nástup zaměstnance%]" Visible="false"></asp:Label>
    <br />
    <telerik:RadWindow runat="server" Title="[%Chyby ve formuláři%]" ID="RW_Errors" AutoSizeBehaviors="Height, Width" MaxHeight="600px" Behaviors="Close, Move, Pin" InitialBehaviors="Close, Move" KeepInScreenBounds="True" Modal="False" VisibleStatusbar="False">
        <ContentTemplate>
            <telerik:RadFormDecorator ID="RFD_decor" runat="server" DecoratedControls="All"
                DecorationZoneID="formsumary" EnableRoundedCorners="False" />
            <div id="formsumary" class="formsumary">
                <asp:ValidationSummary ID="ValidationSummary1" Width="380px" runat="server" />
            </div>
            <kspwc:TRadButton ID="TRB_vs_close" runat="server" AutoPostBack="false" OnClientClicked="RW_Errors_close" Text="[%Zavřít%]">
                <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
            </kspwc:TRadButton>
        </ContentTemplate>
    </telerik:RadWindow>
</asp:Panel>


